/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.spring.webflux5;

import io.cettia.asity.action.Actions;
import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class SpringWebFluxServerWebSocket
extends AbstractServerWebSocket {
    private final WebSocketSession session;
    private final Mono<Void> mono;
    private FluxSink<WebSocketMessage> messageEmitter;

    public SpringWebFluxServerWebSocket(WebSocketSession session) {
        this.session = session;
        session.receive().subscribe(message -> {
            switch (message.getType()) {
                case TEXT: {
                    this.textActions.fire((Object)message.getPayloadAsText());
                    break;
                }
                case BINARY: {
                    this.binaryActions.fire((Object)message.getPayload().asByteBuffer());
                    break;
                }
            }
        }, arg_0 -> ((Actions)this.errorActions).fire(arg_0), () -> ((Actions)this.closeActions).fire());
        Flux flux = Flux.create(messageEmitter -> {
            this.messageEmitter = messageEmitter;
        });
        ConnectableFlux messages = flux.replay();
        messages.connect();
        this.mono = session.send((Publisher)messages);
    }

    public Mono<Void> getMono() {
        return this.mono;
    }

    public String uri() {
        URI uri = this.session.getHandshakeInfo().getUri();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    public Set<String> headerNames() {
        return this.session.getHandshakeInfo().getHeaders().keySet();
    }

    public List<String> headers(String name) {
        return this.session.getHandshakeInfo().getHeaders().get((Object)name);
    }

    protected void doSend(String data) {
        this.messageEmitter.next((Object)this.session.textMessage(data));
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.messageEmitter.next((Object)this.session.binaryMessage(bufferFactory -> bufferFactory.wrap(byteBuffer)));
    }

    protected void doClose() {
        this.messageEmitter.complete();
    }

    public <T> T unwrap(Class<T> clazz) {
        return WebSocketSession.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.session) : null;
    }
}

