/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.spring.webflux5;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.http.AbstractServerHttpExchange;
import io.cettia.asity.http.HttpMethod;
import io.cettia.asity.http.HttpStatus;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class SpringWebFluxServerHttpExchange
extends AbstractServerHttpExchange {
    private final ServerRequest request;
    private final Mono<ServerResponse> serverResponse;
    private ServerHttpResponse response;
    private FluxSink<ByteBuffer> chunkEmitter;

    public SpringWebFluxServerHttpExchange(ServerRequest request) {
        this.request = request;
        Flux flux = Flux.create(chunkEmitter -> {
            this.chunkEmitter = chunkEmitter;
        });
        ConnectableFlux chunks = flux.publish();
        chunks.connect();
        this.serverResponse = ServerResponse.ok().body((response, context) -> {
            this.response = response;
            return response.writeAndFlushWith((Publisher)chunks.map(element -> Mono.just((Object)response.bufferFactory().wrap(element))));
        });
    }

    Mono<ServerResponse> getServerResponse() {
        return this.serverResponse;
    }

    public String uri() {
        URI uri = this.request.uri();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    public HttpMethod method() {
        return HttpMethod.valueOf((String)this.request.methodName());
    }

    public Set<String> headerNames() {
        return this.request.headers().asHttpHeaders().keySet();
    }

    public List<String> headers(String name) {
        return this.request.headers().header(name);
    }

    protected void doRead(Action<ByteBuffer> chunkAction) {
        this.request.bodyToFlux(ByteBuffer.class).subscribe(arg_0 -> chunkAction.on(arg_0), arg_0 -> ((Actions)this.errorActions).fire(arg_0), () -> ((Actions)this.endActions).fire());
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatusCode(org.springframework.http.HttpStatus.valueOf((int)status.code()));
    }

    protected void doSetHeader(String name, String value) {
        this.response.getHeaders().set(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        this.chunkEmitter.next((Object)byteBuffer);
    }

    protected void doEnd() {
        this.chunkEmitter.complete();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(ServerRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (ServerHttpResponse.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null));
    }
}

