/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.netty4;

import io.cettia.asity.action.Action;
import io.cettia.asity.http.AbstractServerHttpExchange;
import io.cettia.asity.http.HttpMethod;
import io.cettia.asity.http.HttpStatus;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class NettyServerHttpExchange
extends AbstractServerHttpExchange {
    private final ChannelHandlerContext context;
    private final HttpRequest request;
    private final HttpResponse response;
    private boolean written;
    private Action<ByteBuffer> chunkAction;

    public NettyServerHttpExchange(ChannelHandlerContext context, HttpRequest request) {
        this.context = context;
        this.request = request;
        this.response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK, false);
        this.response.headers().set("Transfer-Encoding", (Object)"chunked");
    }

    void handleError(Throwable cause) {
        this.errorActions.fire((Object)cause);
    }

    void handleClose() {
        this.closeActions.fire();
    }

    public String uri() {
        return this.request.getUri();
    }

    public HttpMethod method() {
        return HttpMethod.valueOf((String)this.request.getMethod().toString());
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void doRead(Action<ByteBuffer> chunkAction) {
        this.chunkAction = chunkAction;
    }

    void handleChunk(HttpContent chunk) {
        this.read();
        ByteBuf buf = chunk.content();
        if (buf.isReadable() && this.chunkAction != null) {
            this.chunkAction.on((Object)buf.nioBuffer());
        }
        if (chunk instanceof LastHttpContent) {
            this.endActions.fire();
        }
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatus(new HttpResponseStatus(status.code(), status.reason()));
    }

    protected void doSetHeader(String name, String value) {
        this.response.headers().set(name, (Object)value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
        if (!this.written) {
            this.written = true;
            this.context.write((Object)this.response);
        }
        this.context.writeAndFlush((Object)buf);
    }

    protected void doEnd() {
        if (!this.written) {
            this.written = true;
            this.context.write((Object)this.response);
        }
        this.context.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(ChannelHandlerContext.class.isAssignableFrom(clazz) ? clazz.cast(this.context) : (HttpRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (HttpResponse.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null)));
    }
}

