/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.netty4;

import io.cettia.asity.websocket.AbstractServerWebSocket;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;

public class NettyServerWebSocket
extends AbstractServerWebSocket {
    private final ChannelHandlerContext context;
    private final FullHttpRequest request;
    private final WebSocketServerHandshaker handshaker;

    public NettyServerWebSocket(ChannelHandlerContext context, FullHttpRequest req, WebSocketServerHandshaker handshaker) {
        this.context = context;
        this.request = req;
        this.handshaker = handshaker;
    }

    void handleFrame(WebSocketFrame frame) {
        if (frame instanceof TextWebSocketFrame) {
            this.textActions.fire((Object)((TextWebSocketFrame)frame).text());
        } else if (frame instanceof BinaryWebSocketFrame) {
            this.binaryActions.fire((Object)frame.content().nioBuffer());
        } else if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(this.context.channel(), (CloseWebSocketFrame)frame.retain());
            this.closeActions.fire();
        }
    }

    void handleError(Throwable e) {
        this.errorActions.fire((Object)e);
    }

    void handleClose() {
        this.closeActions.fire();
    }

    public String uri() {
        return this.request.getUri();
    }

    public Set<String> headerNames() {
        return this.request.headers().names();
    }

    public List<String> headers(String name) {
        return this.request.headers().getAll(name);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.context.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)));
    }

    protected void doSend(String data) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(data));
    }

    protected void doClose() {
        this.context.close();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(ChannelHandlerContext.class.isAssignableFrom(clazz) ? clazz.cast(this.context) : (WebSocketServerHandshaker.class.isAssignableFrom(clazz) ? clazz.cast(this.handshaker) : (FullHttpRequest.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : null)));
    }
}

