/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.jwa1;

import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;

public class JwaServerWebSocket
extends AbstractServerWebSocket {
    private final Session session;
    private final HandshakeRequest handshakeRequest;
    private final SendHandler sendHandler = result -> {
        if (!result.isOK()) {
            this.errorActions.fire((Object)result.getException());
        }
    };

    public JwaServerWebSocket(Session session) {
        this.session = session;
        this.handshakeRequest = (HandshakeRequest)this.session.getUserProperties().get(HandshakeRequest.class.getName());
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                JwaServerWebSocket.this.textActions.fire((Object)message);
            }
        });
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<ByteBuffer>(){

            public void onMessage(ByteBuffer message) {
                JwaServerWebSocket.this.binaryActions.fire((Object)message);
            }
        });
    }

    void onError(Throwable e) {
        this.errorActions.fire((Object)e);
    }

    void onClose() {
        this.closeActions.fire();
    }

    public String uri() {
        URI uri = this.session.getRequestURI();
        return uri.getPath() + (uri.getQuery() != null ? "?" + uri.getQuery() : "");
    }

    public Set<String> headerNames() {
        return this.handshakeRequest.getHeaders().keySet();
    }

    public List<String> headers(String name) {
        return (List)this.handshakeRequest.getHeaders().get(name);
    }

    protected void doClose() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.session.getAsyncRemote().sendBinary(byteBuffer, this.sendHandler);
    }

    protected void doSend(String data) {
        this.session.getAsyncRemote().sendText(data, this.sendHandler);
    }

    public <T> T unwrap(Class<T> clazz) {
        return Session.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.session) : null;
    }
}

