/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.grizzly2;

import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketAdapter;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class GrizzlyServerWebSocket
extends AbstractServerWebSocket {
    private final DefaultWebSocket socket;

    public GrizzlyServerWebSocket(DefaultWebSocket webSocket) {
        this.socket = webSocket;
        this.socket.add((WebSocketListener)new WebSocketAdapter(){

            public void onMessage(WebSocket socket, String message) {
                GrizzlyServerWebSocket.this.textActions.fire((Object)message);
            }

            public void onMessage(WebSocket socket, byte[] bytes) {
                GrizzlyServerWebSocket.this.binaryActions.fire((Object)ByteBuffer.wrap(bytes));
            }

            public void onClose(WebSocket socket, DataFrame frame) {
                GrizzlyServerWebSocket.this.closeActions.fire();
            }
        });
    }

    void onError(Throwable e) {
        this.errorActions.fire((Object)e);
    }

    public String uri() {
        HttpServletRequest request = this.socket.getUpgradeRequest();
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = uri + "?" + request.getQueryString();
        }
        return uri;
    }

    public Set<String> headerNames() {
        return new LinkedHashSet<String>(Collections.list(this.socket.getUpgradeRequest().getHeaderNames()));
    }

    public List<String> headers(String name) {
        return Collections.list(this.socket.getUpgradeRequest().getHeaders(name));
    }

    protected void doSend(String data) {
        this.socket.send(data);
    }

    protected void doSend(ByteBuffer data) {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.socket.send(bytes);
    }

    protected void doClose() {
        this.socket.close();
    }

    public <T> T unwrap(Class<T> clazz) {
        return WebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.socket) : null;
    }
}

