/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.grizzly2;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.ConcurrentActions;
import io.cettia.asity.bridge.grizzly2.GrizzlyServerWebSocket;
import io.cettia.asity.websocket.ServerWebSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;

public class AsityWebSocketApplication
extends WebSocketApplication {
    private Actions<ServerWebSocket> wsActions = new ConcurrentActions();
    private Map<WebSocket, GrizzlyServerWebSocket> sockets = new ConcurrentHashMap<WebSocket, GrizzlyServerWebSocket>();

    public void onConnect(WebSocket socket) {
        super.onConnect(socket);
        GrizzlyServerWebSocket ws = new GrizzlyServerWebSocket((DefaultWebSocket)socket);
        this.sockets.put(socket, ws);
        this.wsActions.fire((Object)ws);
    }

    public void onClose(WebSocket socket, DataFrame frame) {
        super.onClose(socket, frame);
        this.sockets.remove(socket);
    }

    protected boolean onError(WebSocket webSocket, Throwable t) {
        boolean ret = super.onError(webSocket, t);
        this.sockets.get(webSocket).onError(t);
        return ret;
    }

    public AsityWebSocketApplication onwebsocket(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }
}

