/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.grizzly2;

import io.cettia.asity.action.Action;
import io.cettia.asity.http.AbstractServerHttpExchange;
import io.cettia.asity.http.HttpMethod;
import io.cettia.asity.http.HttpStatus;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.ICloseType;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.NIOInputStream;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;

public class GrizzlyServerHttpExchange
extends AbstractServerHttpExchange {
    private final Request request;
    private final Response response;

    public GrizzlyServerHttpExchange(Request request, Response response) {
        this.request = request;
        this.response = response;
        request.getContext().getConnection().addCloseListener((CloseListener)new CloseListener<Closeable, ICloseType>(){

            public void onClosed(Closeable closeable, ICloseType type) throws IOException {
                GrizzlyServerHttpExchange.this.closeActions.fire();
            }
        });
        request.getInputBuffer().initiateAsyncronousDataReceiving();
        response.suspend();
    }

    public String uri() {
        String uri = this.request.getRequestURI();
        if (this.request.getQueryString() != null) {
            uri = uri + "?" + this.request.getQueryString();
        }
        return uri;
    }

    public HttpMethod method() {
        return HttpMethod.valueOf((String)this.request.getMethod().getMethodString());
    }

    public Set<String> headerNames() {
        LinkedHashSet<String> headerNames = new LinkedHashSet<String>();
        for (String headerName : this.request.getHeaderNames()) {
            headerNames.add(headerName);
        }
        return headerNames;
    }

    public List<String> headers(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        for (String header : this.request.getHeaders(name)) {
            headers.add(header);
        }
        return headers;
    }

    protected void doRead(final Action<ByteBuffer> chunkAction) {
        final NIOInputStream in = this.request.getNIOInputStream();
        in.notifyAvailable(new ReadHandler(){

            public void onDataAvailable() throws Exception {
                int bytesRead = -1;
                byte[] buffer = new byte[8192];
                while (in.isReady() && (bytesRead = in.read(buffer)) != -1) {
                    chunkAction.on((Object)ByteBuffer.wrap(buffer, 0, bytesRead));
                }
            }

            public void onAllDataRead() throws Exception {
                this.onDataAvailable();
                GrizzlyServerHttpExchange.this.endActions.fire();
            }

            public void onError(Throwable t) {
                GrizzlyServerHttpExchange.this.errorActions.fire((Object)t);
            }
        });
    }

    protected void doSetStatus(HttpStatus status) {
        this.response.setStatus(status.code(), status.reason());
    }

    protected void doSetHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    protected void doWrite(ByteBuffer byteBuffer) {
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            NIOOutputStream out = this.response.getNIOOutputStream();
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doEnd() {
        this.response.resume();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)(Request.class.isAssignableFrom(clazz) ? clazz.cast(this.request) : (Response.class.isAssignableFrom(clazz) ? clazz.cast(this.response) : null));
    }
}

