/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.atmosphere2;

import io.cettia.asity.websocket.AbstractServerWebSocket;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.websocket.WebSocketEventListener;
import org.atmosphere.websocket.WebSocketEventListenerAdapter;

public class AtmosphereServerWebSocket
extends AbstractServerWebSocket {
    private final AtmosphereResource resource;

    public AtmosphereServerWebSocket(AtmosphereResource resource) {
        this.resource = resource;
        resource.addEventListener((AtmosphereResourceEventListener)new AtmosphereResourceEventListenerAdapter(){

            public void onClose(AtmosphereResourceEvent event) {
                AtmosphereServerWebSocket.this.closeActions.fire();
            }

            public void onDisconnect(AtmosphereResourceEvent event) {
                AtmosphereServerWebSocket.this.closeActions.fire();
            }

            public void onThrowable(AtmosphereResourceEvent event) {
                AtmosphereServerWebSocket.this.errorActions.fire((Object)event.throwable());
            }
        }).addEventListener((AtmosphereResourceEventListener)new WebSocketEventListenerAdapter(){

            public void onMessage(WebSocketEventListener.WebSocketEvent event) {
                Object message = event.message();
                if (message instanceof String) {
                    AtmosphereServerWebSocket.this.textActions.fire((Object)((String)message));
                } else if (message instanceof byte[]) {
                    AtmosphereServerWebSocket.this.binaryActions.fire((Object)ByteBuffer.wrap((byte[])message));
                } else {
                    AtmosphereServerWebSocket.this.errorActions.fire((Object)new IllegalStateException("Message is neither String nor byte[]"));
                }
            }
        });
    }

    public String uri() {
        String uri = this.resource.getRequest().getRequestURI();
        if (this.resource.getRequest().getQueryString() != null) {
            uri = uri + "?" + this.resource.getRequest().getQueryString();
        }
        return uri;
    }

    public Set<String> headerNames() {
        return new LinkedHashSet<String>(Collections.list(this.resource.getRequest().getHeaderNames()));
    }

    public List<String> headers(String name) {
        return Collections.list(this.resource.getRequest().getHeaders(name));
    }

    protected void doSend(String data) {
        this.resource.forceBinaryWrite(false);
        try {
            PrintWriter writer = this.resource.getResponse().getWriter();
            writer.print(data);
            writer.flush();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.resource.forceBinaryWrite(true);
        try {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            ServletOutputStream outputStream = this.resource.getResponse().getOutputStream();
            outputStream.write(bytes);
            outputStream.flush();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    protected void doClose() {
        try {
            this.resource.close();
        }
        catch (IOException e) {
            this.errorActions.fire((Object)e);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return AtmosphereResource.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.resource) : null;
    }
}

