/*
 * Decompiled with CFR 0.152.
 */
package io.cettia.asity.bridge.atmosphere2;

import io.cettia.asity.action.Action;
import io.cettia.asity.action.Actions;
import io.cettia.asity.action.ConcurrentActions;
import io.cettia.asity.bridge.atmosphere2.AtmosphereServerHttpExchange;
import io.cettia.asity.bridge.atmosphere2.AtmosphereServerWebSocket;
import io.cettia.asity.http.ServerHttpExchange;
import io.cettia.asity.websocket.ServerWebSocket;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.handler.AtmosphereHandlerAdapter;

public class AsityAtmosphereServlet
extends AtmosphereServlet {
    private Actions<ServerHttpExchange> httpActions = new ConcurrentActions();
    private Actions<ServerWebSocket> wsActions = new ConcurrentActions();

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.framework().addAtmosphereHandler("/", (AtmosphereHandler)new AtmosphereHandlerAdapter(){

            public void onRequest(AtmosphereResource resource) throws IOException {
                if (AsityAtmosphereServlet.this.isWebSocketResource(resource)) {
                    if (resource.getRequest().getMethod().equals("GET")) {
                        AsityAtmosphereServlet.this.wsActions.fire((Object)new AtmosphereServerWebSocket(resource));
                    }
                } else {
                    AsityAtmosphereServlet.this.httpActions.fire((Object)new AtmosphereServerHttpExchange(resource));
                }
            }
        });
    }

    protected boolean isWebSocketResource(AtmosphereResource resource) {
        return resource.getResponse().getResponse() instanceof AtmosphereResponse;
    }

    public AsityAtmosphereServlet onhttp(Action<ServerHttpExchange> action) {
        this.httpActions.add(action);
        return this;
    }

    public AsityAtmosphereServlet onwebsocket(Action<ServerWebSocket> action) {
        this.wsActions.add(action);
        return this;
    }
}

