/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler;

import io.cdap.wrangler.PreconditionException;
import io.cdap.wrangler.api.Row;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;

public class Precondition {
    private final String condition;
    private final CompiledScript script;
    private final ThreadLocal<ScriptContext> contextCache = ThreadLocal.withInitial(this::createContext);

    public Precondition(String condition) throws PreconditionException {
        this.condition = condition;
        JexlScriptEngine engine = new JexlScriptEngine();
        try {
            this.script = engine.compile(condition);
        }
        catch (ScriptException e) {
            if (e.getCause() != null) {
                throw new PreconditionException(e.getCause().getMessage());
            }
            throw new PreconditionException(e.getMessage());
        }
    }

    public ScriptContext createContext() {
        ScriptContext parent = this.script.getEngine().getContext();
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(parent.getBindings(200), 200);
        context.setWriter(parent.getWriter());
        context.setReader(parent.getReader());
        context.setErrorWriter(parent.getErrorWriter());
        return context;
    }

    public boolean apply(Row row) throws PreconditionException {
        SimpleBindings bindings = new SimpleBindings();
        for (int i = 0; i < row.width(); ++i) {
            bindings.put(row.getColumn(i), row.getValue(i));
        }
        try {
            ScriptContext scriptContext = this.contextCache.get();
            scriptContext.setBindings(bindings, 100);
            Object result = this.script.eval(scriptContext);
            if (!(result instanceof Boolean)) {
                throw new PreconditionException(String.format("Precondition '%s' does not result in true or false.", this.condition));
            }
            return (Boolean)result;
        }
        catch (ScriptException e) {
            if (e.getCause() != null) {
                throw new PreconditionException(e.getCause().getMessage());
            }
            throw new PreconditionException(e.getMessage());
        }
    }
}

