/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler;

import io.cdap.cdap.etl.api.Lookup;
import io.cdap.cdap.etl.api.StageMetrics;
import io.cdap.cdap.etl.api.TransformContext;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.TransientStore;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class WranglerPipelineContext
implements ExecutorContext {
    private final ExecutorContext.Environment environment;
    private final TransformContext context;
    private final TransientStore store;
    private StageMetrics metrics;
    private String name;
    private Map<String, String> properties;

    WranglerPipelineContext(ExecutorContext.Environment environment, TransformContext context, TransientStore store) {
        this.environment = environment;
        this.metrics = context.getMetrics();
        this.name = context.getStageName();
        this.properties = new HashMap<String, String>(context.getPluginProperties().getProperties());
        for (Map.Entry next : context.getArguments()) {
            this.properties.put((String)next.getKey(), (String)next.getValue());
        }
        this.context = context;
        this.store = store;
    }

    public String getNamespace() {
        return this.context.getNamespace();
    }

    public ExecutorContext.Environment getEnvironment() {
        return this.environment;
    }

    public StageMetrics getMetrics() {
        return this.metrics;
    }

    public String getContextName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public URL getService(String applicationId, String serviceId) {
        return this.context.getServiceURL(applicationId, serviceId);
    }

    public TransientStore getTransientStore() {
        return this.store;
    }

    public <T> Lookup<T> provide(String s, Map<String, String> map) {
        return this.context.provide(s, map);
    }
}

