/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler;

import io.cdap.wrangler.PreconditionException;
import io.cdap.wrangler.api.Row;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.jexl3.scripting.JexlScriptEngine;

public class Precondition {
    private final String condition;
    private final CompiledScript script;

    public Precondition(String condition) throws PreconditionException {
        this.condition = condition;
        JexlScriptEngine engine = new JexlScriptEngine();
        try {
            this.script = engine.compile(condition);
        }
        catch (ScriptException e) {
            if (e.getCause() != null) {
                throw new PreconditionException(e.getCause().getMessage());
            }
            throw new PreconditionException(e.getMessage());
        }
    }

    public boolean apply(Row row) throws PreconditionException {
        SimpleBindings ctx = new SimpleBindings();
        for (int i = 0; i < row.length(); ++i) {
            ctx.put(row.getColumn(i), row.getValue(i));
        }
        try {
            Object result = this.script.eval(ctx);
            if (!(result instanceof Boolean)) {
                throw new PreconditionException(String.format("Precondition '%s' does not result in true or false.", this.condition));
            }
            return (Boolean)result;
        }
        catch (ScriptException e) {
            if (e.getCause() != null) {
                throw new PreconditionException(e.getCause().getMessage());
            }
            throw new PreconditionException(e.getMessage());
        }
    }
}

