/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Row;
import java.nio.ByteBuffer;

public class StructuredToRowTransformer {
    private StructuredToRowTransformer() {
    }

    public static Row transform(StructuredRecord record) {
        Row row = new Row();
        for (Schema.Field field : record.getSchema().getFields()) {
            row.add(field.getName(), StructuredToRowTransformer.getValue(record, field.getName()));
        }
        return row;
    }

    public static Object getValue(StructuredRecord input, String fieldName) {
        Schema fieldSchema = input.getSchema().getField(fieldName).getSchema();
        fieldSchema = fieldSchema.isNullable() ? fieldSchema.getNonNullable() : fieldSchema;
        Schema.LogicalType logicalType = fieldSchema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType) {
                case DATE: {
                    return input.getDate(fieldName);
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    return input.getTime(fieldName);
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return input.getTimestamp(fieldName);
                }
                case DECIMAL: {
                    return input.getDecimal(fieldName);
                }
                case DATETIME: {
                    return input.getDateTime(fieldName);
                }
            }
            throw new UnexpectedFormatException("Field type " + logicalType + " is not supported.");
        }
        if (fieldSchema.getType().equals((Object)Schema.Type.BYTES)) {
            Object val = input.get(fieldName);
            return val instanceof ByteBuffer ? (Object)Bytes.toBytes((ByteBuffer)((ByteBuffer)val)) : val;
        }
        return input.get(fieldName);
    }
}

