/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.utils.RecordConvertorException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RecordConvertor
implements Serializable {
    public List<StructuredRecord> toStructureRecord(List<Row> rows, Schema schema) throws RecordConvertorException {
        ArrayList<StructuredRecord> results = new ArrayList<StructuredRecord>();
        for (Row row : rows) {
            StructuredRecord r = this.decodeRecord(row, schema);
            results.add(r);
        }
        return results;
    }

    public StructuredRecord decodeRecord(Row row, Schema schema) throws RecordConvertorException {
        Object cell;
        if (row.getFields().size() == 1 && (cell = row.getValue(0)) instanceof StructuredRecord) {
            return (StructuredRecord)cell;
        }
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        List fields = schema.getFields();
        int firstUnclaimedField = 0;
        for (Schema.Field field : fields) {
            Schema fSchema = field.getSchema();
            boolean isNullable = fSchema.isNullable();
            String name = field.getName();
            Object value = null;
            int idx = -1;
            if (name.equals(row.getColumn(firstUnclaimedField))) {
                idx = firstUnclaimedField++;
            } else {
                idx = row.find(name, firstUnclaimedField);
                if (idx == firstUnclaimedField) {
                    ++firstUnclaimedField;
                }
            }
            if (idx != -1) {
                value = row.getValue(idx);
            }
            try {
                Object decodedObj = this.decode(name, value, field.getSchema());
                if (decodedObj instanceof LocalDate) {
                    builder.setDate(name, (LocalDate)decodedObj);
                    continue;
                }
                if (decodedObj instanceof LocalTime) {
                    builder.setTime(name, (LocalTime)decodedObj);
                    continue;
                }
                if (decodedObj instanceof ZonedDateTime) {
                    builder.setTimestamp(name, (ZonedDateTime)decodedObj);
                    continue;
                }
                if (decodedObj instanceof BigDecimal) {
                    builder.setDecimal(name, (BigDecimal)decodedObj);
                    continue;
                }
                if (decodedObj instanceof LocalDateTime) {
                    builder.setDateTime(name, (LocalDateTime)decodedObj);
                    continue;
                }
                builder.set(name, decodedObj);
            }
            catch (UnexpectedFormatException e) {
                throw new RecordConvertorException(String.format("Field '%s' of type '%s' cannot be set to '%s'. Make sure the value is being set is inline with the specified schema.", name, isNullable ? fSchema.getNonNullable().getDisplayName() : fSchema.getDisplayName(), value == null ? "NULL" : value), e);
            }
        }
        return builder.build();
    }

    private Object decode(String name, Object object, Schema schema) throws RecordConvertorException {
        Schema.LogicalType logicalType;
        Schema.Type type = schema.getType();
        Schema.LogicalType logicalType2 = logicalType = schema.isNullable() ? schema.getNonNullable().getLogicalType() : schema.getLogicalType();
        if (logicalType != null) {
            switch (logicalType) {
                case DATETIME: {
                    if (schema.isNullable() && object == null || object instanceof LocalDateTime) {
                        return object;
                    }
                    if (object == null) {
                        throw new UnexpectedFormatException(String.format("Datetime field %s should have a non null value", name));
                    }
                    try {
                        LocalDateTime.parse((String)object);
                    }
                    catch (DateTimeParseException exception) {
                        throw new UnexpectedFormatException(String.format("Datetime field '%s' with value '%s' is not in ISO-8601 format.", name, object), (Throwable)exception);
                    }
                    return object;
                }
                case DATE: 
                case TIME_MILLIS: 
                case TIME_MICROS: 
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: 
                case DECIMAL: {
                    return object;
                }
            }
            throw new UnexpectedFormatException("field type " + logicalType + " is not supported.");
        }
        switch (type) {
            case NULL: 
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: 
            case STRING: {
                return this.decodeSimpleTypes(name, object, schema);
            }
            case ENUM: {
                break;
            }
            case ARRAY: {
                return this.decodeArray(name, object, schema.getComponentSchema());
            }
            case RECORD: {
                return this.decodeRecord(name, object, schema);
            }
            case MAP: {
                Schema key = (Schema)schema.getMapSchema().getKey();
                Schema value = (Schema)schema.getMapSchema().getValue();
                return this.decodeMap(name, (Map)object, key, value);
            }
            case UNION: {
                return this.decodeUnion(name, object, schema.getUnionSchemas());
            }
        }
        throw new RecordConvertorException(String.format("Unable decode object '%s' with schema type '%s'.", name, type.toString()));
    }

    private StructuredRecord decodeRecord(String name, Object object, Schema schema) throws RecordConvertorException {
        if (object instanceof StructuredRecord) {
            return (StructuredRecord)object;
        }
        if (object instanceof Map) {
            return this.decodeRecord(name, (Map)object, schema);
        }
        if (object instanceof JsonObject) {
            return this.decodeRecord(name, (JsonObject)object, schema);
        }
        if (object instanceof JsonArray) {
            List<Object> values = this.decodeArray(name, object, schema.getComponentSchema());
            StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
            builder.set(name, values);
            return builder.build();
        }
        throw new RecordConvertorException(String.format("Unable decode object '%s' with schema type '%s'.", name, schema.getType().toString()));
    }

    private StructuredRecord decodeRecord(String name, JsonObject nativeObject, Schema schema) throws RecordConvertorException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        for (Schema.Field field : schema.getFields()) {
            String fieldName = field.getName();
            JsonElement fieldVal = nativeObject.get(fieldName);
            builder.set(fieldName, this.decode(name, fieldVal, field.getSchema()));
        }
        return builder.build();
    }

    private StructuredRecord decodeRecord(String name, Map nativeObject, Schema schema) throws RecordConvertorException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        for (Schema.Field field : schema.getFields()) {
            String fieldName = field.getName();
            Object fieldVal = nativeObject.get(fieldName);
            builder.set(fieldName, this.decode(name, fieldVal, field.getSchema()));
        }
        return builder.build();
    }

    private Object decodeSimpleTypes(String name, Object object, Schema schema) throws RecordConvertorException {
        String val;
        Schema.Type type = schema.getType();
        if (object == null || JsonNull.INSTANCE.equals(object)) {
            return null;
        }
        if (object instanceof JsonPrimitive) {
            return JsParser.getValue((JsonPrimitive)object);
        }
        if (type != Schema.Type.STRING && object instanceof String && (val = (String)object).trim().isEmpty()) {
            return null;
        }
        switch (type) {
            case NULL: {
                return null;
            }
            case INT: {
                String value;
                if (object instanceof Integer || object instanceof Short) {
                    return (Integer)object;
                }
                if (object instanceof String) {
                    value = (String)object;
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        throw new RecordConvertorException(String.format("Unable to convert '%s' to integer for field name '%s'", value, name), e);
                    }
                }
                throw new RecordConvertorException(String.format("Schema specifies field '%s' is integer, but the value is not a integer or string. It is of type '%s'", name, object.getClass().getSimpleName()));
            }
            case LONG: {
                String value;
                if (object instanceof Long) {
                    return (Long)object;
                }
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Short) {
                    return ((Short)object).longValue();
                }
                if (object instanceof String) {
                    value = (String)object;
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        throw new RecordConvertorException(String.format("Unable to convert '%s' to long for field name '%s'", value, name), e);
                    }
                }
                throw new RecordConvertorException(String.format("Schema specifies field '%s' is long, but the value is nor a string or long. It is of type '%s'", name, object.getClass().getSimpleName()));
            }
            case FLOAT: {
                String value;
                if (object instanceof Float) {
                    return (Float)object;
                }
                if (object instanceof Long) {
                    return Float.valueOf(((Long)object).floatValue());
                }
                if (object instanceof Integer) {
                    return Float.valueOf(((Integer)object).floatValue());
                }
                if (object instanceof Short) {
                    return Float.valueOf(((Short)object).floatValue());
                }
                if (object instanceof String) {
                    value = (String)object;
                    try {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        throw new RecordConvertorException(String.format("Unable to convert '%s' to float for field name '%s'", value, name), e);
                    }
                }
                throw new RecordConvertorException(String.format("Schema specifies field '%s' is float, but the value is nor a string or float. It is of type '%s'", name, object.getClass().getSimpleName()));
            }
            case DOUBLE: {
                String value;
                if (object instanceof Double) {
                    return (Double)object;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).doubleValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).doubleValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).doubleValue();
                }
                if (object instanceof Short) {
                    return ((Short)object).doubleValue();
                }
                if (object instanceof String) {
                    value = (String)object;
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        throw new RecordConvertorException(String.format("Unable to convert '%s' to double for field name '%s'", value, name), e);
                    }
                }
                throw new RecordConvertorException(String.format("Schema specifies field '%s' is double, but the value is nor a string or double. It is of type '%s'", name, object.getClass().getSimpleName()));
            }
            case BOOLEAN: {
                String value;
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                if (object instanceof String) {
                    value = (String)object;
                    try {
                        return Boolean.parseBoolean(value);
                    }
                    catch (NumberFormatException e) {
                        throw new RecordConvertorException(String.format("Unable to convert '%s' to boolean for field name '%s'", value, name), e);
                    }
                }
                throw new RecordConvertorException(String.format("Schema specifies field '%s' is double, but the value is nor a string or boolean. It is of type '%s'", name, object.getClass().getSimpleName()));
            }
            case STRING: {
                return object.toString();
            }
            case BYTES: {
                if (object instanceof byte[]) {
                    return (byte[])object;
                }
                if (object instanceof Boolean) {
                    return Bytes.toBytes((boolean)((Boolean)object));
                }
                if (object instanceof Double) {
                    return Bytes.toBytes((double)((Double)object));
                }
                if (object instanceof Float) {
                    return Bytes.toBytes((float)((Float)object).floatValue());
                }
                if (object instanceof Long) {
                    return Bytes.toBytes((long)((Long)object));
                }
                if (object instanceof Integer) {
                    return Bytes.toBytes((int)((Integer)object));
                }
                if (object instanceof Short) {
                    return Bytes.toBytes((short)((Short)object));
                }
                if (object instanceof String) {
                    return Bytes.toBytes((String)((String)object));
                }
                if (object instanceof BigDecimal) {
                    return Bytes.toBytes((BigDecimal)((BigDecimal)object));
                }
                throw new RecordConvertorException(String.format("Unable to convert '%s' to bytes for field name '%s'", object.toString(), name));
            }
        }
        throw new RecordConvertorException(String.format("Unable decode object '%s' with schema type '%s'.", name, type.toString()));
    }

    private Map<Object, Object> decodeMap(String name, Map<Object, Object> object, Schema key, Schema value) throws RecordConvertorException {
        HashMap output = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : object.entrySet()) {
            output.put(this.decode(name, entry.getKey(), key), this.decode(name, entry.getValue(), value));
        }
        return output;
    }

    private Object decodeUnion(String name, Object object, List<Schema> schemas) throws RecordConvertorException {
        Iterator<Schema> iterator = schemas.iterator();
        if (iterator.hasNext()) {
            Schema schema = iterator.next();
            return this.decode(name, object, schema);
        }
        throw new RecordConvertorException(String.format("Unable decode object '%s'.", name));
    }

    private List<Object> decodeArray(String name, Object object, Schema schema) throws RecordConvertorException {
        if (object instanceof List) {
            return this.decodeArray(name, (List)object, schema);
        }
        if (object instanceof JsonArray) {
            return this.decodeArray(name, (JsonArray)object, schema);
        }
        throw new RecordConvertorException(String.format("Unable to decode array '%s'", name));
    }

    private List<Object> decodeArray(String name, JsonArray list, Schema schema) throws RecordConvertorException {
        ArrayList array = Lists.newArrayListWithCapacity((int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            array.add(this.decode(name, list.get(i), schema));
        }
        return array;
    }

    private List<Object> decodeArray(String name, List list, Schema schema) throws RecordConvertorException {
        ArrayList array = Lists.newArrayListWithCapacity((int)list.size());
        for (Object object : list) {
            array.add(this.decode(name, object, schema));
        }
        return array;
    }
}

