/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Manifest
implements Serializable {
    private final Map<String, Standard> standards;

    public Manifest(Map<String, Standard> standards) {
        this.standards = Collections.unmodifiableMap(new HashMap<String, Standard>(standards));
    }

    public Map<String, Standard> getStandards() {
        return this.standards;
    }

    public static final class Standard {
        private final String hash;
        private final String format;

        public Standard(String hash, String format) {
            this.hash = hash;
            this.format = format;
        }

        public String getHash() {
            return this.hash;
        }

        public String getFormat() {
            return this.format;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Standard standard = (Standard)o;
            return Objects.equals(this.hash, standard.hash) && Objects.equals(this.format, standard.format);
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.format);
        }

        public String toString() {
            return "Standard{hash='" + this.hash + '\'' + ", format='" + this.format + '\'' + '}';
        }
    }
}

