/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.Row;
import java.math.BigDecimal;

public final class ColumnConverter {
    private ColumnConverter() {
    }

    public static void rename(String directiveName, Row row, String column, String toName) throws DirectiveExecutionException {
        int idx = row.find(column);
        int existingColumn = row.find(toName);
        if (idx == -1) {
            return;
        }
        if (existingColumn != -1 && idx != existingColumn) {
            throw new DirectiveExecutionException(directiveName, String.format("Column '%s' already exists. Apply the 'drop %s' directive before renaming '%s' to '%s'.", toName, toName, column, toName));
        }
        row.setColumn(idx, toName);
    }

    public static void convertType(String directiveName, Row row, String column, String toType) throws DirectiveExecutionException {
        int idx = row.find(column);
        if (idx != -1) {
            Object object = row.getValue(idx);
            if (object == null || object instanceof String && ((String)object).trim().isEmpty()) {
                return;
            }
            try {
                row.setValue(idx, ColumnConverter.convertType(column, toType, object));
            }
            catch (DirectiveExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DirectiveExecutionException(directiveName, String.format("Column '%s' cannot be converted to a '%s'.", column, toType), (Throwable)e);
            }
        }
    }

    private static Object convertType(String col, String toType, Object object) throws Exception {
        switch (toType = toType.toUpperCase()) {
            case "INTEGER": 
            case "I64": 
            case "INT": {
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).intValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).intValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).intValue();
                }
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Long) {
                    return ((Long)object).intValue();
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).intValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toInt((byte[])((byte[])object));
            }
            case "I32": 
            case "SHORT": {
                if (object instanceof String) {
                    return Short.parseShort((String)object);
                }
                if (object instanceof Short) {
                    return object;
                }
                if (object instanceof Float) {
                    return ((Float)object).shortValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).shortValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).shortValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).shortValue();
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).shortValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toShort((byte[])((byte[])object));
            }
            case "LONG": {
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).longValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).longValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).longValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Long) {
                    return object;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).longValue();
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toLong((byte[])((byte[])object));
            }
            case "BOOL": 
            case "BOOLEAN": {
                if (object instanceof Boolean) {
                    return object;
                }
                if (object instanceof String) {
                    return Boolean.parseBoolean((String)object);
                }
                if (object instanceof Short) {
                    return (Short)object > 0;
                }
                if (object instanceof Float) {
                    return ((Float)object).floatValue() > 0.0f;
                }
                if (object instanceof Double) {
                    return (Double)object > 0.0;
                }
                if (object instanceof Integer) {
                    return (Integer)object > 0;
                }
                if (object instanceof Long) {
                    return (Long)object > 0L;
                }
                if (object instanceof BigDecimal) {
                    return ((BigDecimal)object).compareTo(BigDecimal.ZERO) > 0;
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toBoolean((byte[])((byte[])object));
            }
            case "STRING": {
                if (object instanceof byte[]) {
                    return Bytes.toString((byte[])((byte[])object));
                }
                return object.toString();
            }
            case "FLOAT": {
                if (object instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)object));
                }
                if (object instanceof Short) {
                    return Float.valueOf(((Short)object).floatValue());
                }
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Double) {
                    return Float.valueOf(((Double)object).floatValue());
                }
                if (object instanceof Integer) {
                    return Float.valueOf(((Integer)object).floatValue());
                }
                if (object instanceof Long) {
                    return Float.valueOf(((Long)object).floatValue());
                }
                if (object instanceof BigDecimal) {
                    return Float.valueOf(((BigDecimal)object).floatValue());
                }
                if (!(object instanceof byte[])) break;
                return Float.valueOf(Bytes.toFloat((byte[])((byte[])object)));
            }
            case "DECIMAL": {
                if (object instanceof BigDecimal) {
                    return object;
                }
                if (object instanceof String) {
                    return new BigDecimal((String)object);
                }
                if (object instanceof Integer) {
                    return BigDecimal.valueOf(((Integer)object).intValue());
                }
                if (object instanceof Short) {
                    return BigDecimal.valueOf(((Short)object).shortValue());
                }
                if (object instanceof Long) {
                    return BigDecimal.valueOf((Long)object);
                }
                if (object instanceof Float) {
                    return BigDecimal.valueOf(((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return BigDecimal.valueOf((Double)object);
                }
                if (!(object instanceof byte[])) break;
                return Bytes.toBigDecimal((byte[])((byte[])object));
            }
            case "DOUBLE": {
                if (object instanceof String) {
                    return Double.parseDouble((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).doubleValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Integer) {
                    return ((Integer)object).doubleValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).doubleValue();
                }
                if (object instanceof byte[]) {
                    return Bytes.toDouble((byte[])((byte[])object));
                }
                if (!(object instanceof BigDecimal)) break;
                return ((BigDecimal)object).doubleValue();
            }
            case "BYTES": {
                if (object instanceof String) {
                    return Bytes.toBytes((String)((String)object));
                }
                if (object instanceof Short) {
                    return Bytes.toBytes((short)((Short)object));
                }
                if (object instanceof Float) {
                    return Bytes.toBytes((float)((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return Bytes.toBytes((double)((Double)object));
                }
                if (object instanceof Integer) {
                    return Bytes.toBytes((int)((Integer)object));
                }
                if (object instanceof Long) {
                    return Bytes.toBytes((long)((Long)object));
                }
                if (object instanceof BigDecimal) {
                    return Bytes.toBytes((BigDecimal)((BigDecimal)object));
                }
                if (!(object instanceof byte[])) break;
                return object;
            }
            default: {
                throw new DirectiveExecutionException(String.format("Column '%s' is of unsupported type '%s'. Supported types are: int, short, long, double, decimal, boolean, string, bytes", col, toType));
            }
        }
        throw new DirectiveExecutionException(String.format("Column '%s' has value of type '%s' and cannot be converted to a '%s'.", col, object.getClass().getSimpleName(), toType));
    }
}

