/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class ArithmeticOperations {
    public static Integer add(Integer x, Integer y) {
        if (x == null || y == null) {
            return null;
        }
        return x + y;
    }

    public static Double add(Double x, Double y) {
        if (x == null || y == null) {
            return null;
        }
        return x + y;
    }

    public static Float add(Float x, Float y) {
        if (x == null || y == null) {
            return null;
        }
        return Float.valueOf(x.floatValue() + y.floatValue());
    }

    public static BigDecimal add(BigDecimal x, BigDecimal y) {
        if (x == null || y == null) {
            return null;
        }
        return x.add(y).stripTrailingZeros();
    }

    public static Integer minus(Integer x, Integer y) {
        if (x == null || y == null) {
            return null;
        }
        return x - y;
    }

    public static Double minus(Double x, Double y) {
        if (x == null || y == null) {
            return null;
        }
        return x - y;
    }

    public static Float minus(Float x, Float y) {
        if (x == null || y == null) {
            return null;
        }
        return Float.valueOf(x.floatValue() - y.floatValue());
    }

    public static BigDecimal minus(BigDecimal x, BigDecimal y) {
        if (x == null || y == null) {
            return null;
        }
        return x.subtract(y).stripTrailingZeros();
    }

    public static Integer multiply(Integer x, Integer y) {
        if (x == null || y == null) {
            return null;
        }
        return x * y;
    }

    public static Double multiply(Double x, Double y) {
        if (x == null || y == null) {
            return null;
        }
        return x * y;
    }

    public static Float multiply(Float x, Float y) {
        if (x == null || y == null) {
            return null;
        }
        return Float.valueOf(x.floatValue() * y.floatValue());
    }

    public static BigDecimal multiply(BigDecimal x, BigDecimal y) {
        if (x == null || y == null) {
            return null;
        }
        return x.multiply(y);
    }

    public static Integer divideq(Integer x, Integer y) {
        if (x == null || y == null || y == 0) {
            return null;
        }
        return x / y;
    }

    public static Double divideq(Double x, Double y) {
        if (x == null || y == null || y == 0.0) {
            return null;
        }
        return x / y;
    }

    public static Float divideq(Float x, Float y) {
        if (x == null || y == null || y.floatValue() == 0.0f) {
            return null;
        }
        return Float.valueOf(x.floatValue() / y.floatValue());
    }

    public static BigDecimal divideq(BigDecimal x, BigDecimal y) {
        if (x == null || y == null || y.equals(BigDecimal.valueOf(0L))) {
            return null;
        }
        return x.divide(y, 6).stripTrailingZeros();
    }

    public static Integer divider(Integer x, Integer y) {
        if (x == null || y == null || y == 0) {
            return null;
        }
        return x % y;
    }

    public static Double divider(Double x, Double y) {
        if (x == null || y == null || y == 0.0) {
            return null;
        }
        return x % y;
    }

    public static Float divider(Float x, Float y) {
        if (x == null || y == null || y.floatValue() == 0.0f) {
            return null;
        }
        return Float.valueOf(x.floatValue() % y.floatValue());
    }

    public static BigDecimal divider(BigDecimal x, BigDecimal y) {
        if (x == null || y == null || y.equals(BigDecimal.valueOf(0L))) {
            return null;
        }
        return x.remainder(y);
    }

    public static Integer lcm(Integer i1, Integer i2) {
        if (i1 == null || i2 == null) {
            return null;
        }
        BigDecimal bd1 = BigDecimal.valueOf(i1.intValue());
        BigDecimal bd2 = BigDecimal.valueOf(i2.intValue());
        return ArithmeticOperations.lcm(bd1, bd2).intValue();
    }

    public static Double lcm(Double d1, Double d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        BigDecimal bd1 = BigDecimal.valueOf(d1);
        BigDecimal bd2 = BigDecimal.valueOf(d2);
        return ArithmeticOperations.lcm(bd1, bd2).doubleValue();
    }

    public static Float lcm(Float f1, Float f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        BigDecimal bd1 = BigDecimal.valueOf(f1.floatValue());
        BigDecimal bd2 = BigDecimal.valueOf(f2.floatValue());
        return Float.valueOf(ArithmeticOperations.lcm(bd1, bd2).floatValue());
    }

    public static BigDecimal lcm(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return null;
        }
        BigDecimal pow = BigDecimal.valueOf(Math.pow(10.0, Math.max(bd1.scale(), bd2.scale())));
        BigInteger val1 = bd1.multiply(pow).toBigInteger();
        BigInteger val2 = bd2.multiply(pow).toBigInteger();
        BigDecimal absProduct = new BigDecimal(val1.multiply(val2).abs()).setScale(Math.min(bd1.scale(), bd2.scale()), 6);
        BigDecimal gcd = new BigDecimal(val1.gcd(val2));
        if (gcd.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return absProduct.divide(gcd.multiply(pow), 6);
    }

    public static Boolean equal(Integer i1, Integer i2) {
        if (i1 == null || i2 == null) {
            return null;
        }
        return i1.equals(i2);
    }

    public static Boolean equal(Double d1, Double d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return d1.equals(d2);
    }

    public static Boolean equal(Float f1, Float f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        return f1.equals(f2);
    }

    public static Boolean equal(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return null;
        }
        return bd1.equals(bd2);
    }

    public static Integer max(Integer i1, Integer i2) {
        if (i1 == null || i2 == null) {
            return null;
        }
        return Math.max(i1, i2);
    }

    public static Double max(Double d1, Double d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return Math.max(d1, d2);
    }

    public static Float max(Float f1, Float f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        return Float.valueOf(Math.max(f1.floatValue(), f2.floatValue()));
    }

    public static BigDecimal max(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return null;
        }
        return bd1.max(bd2);
    }

    public static Integer min(Integer i1, Integer i2) {
        if (i1 == null || i2 == null) {
            return null;
        }
        return Math.min(i1, i2);
    }

    public static Double min(Double d1, Double d2) {
        if (d1 == null || d2 == null) {
            return null;
        }
        return Math.min(d1, d2);
    }

    public static Float min(Float f1, Float f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        return Float.valueOf(Math.min(f1.floatValue(), f2.floatValue()));
    }

    public static BigDecimal min(BigDecimal bd1, BigDecimal bd2) {
        if (bd1 == null || bd2 == null) {
            return null;
        }
        return bd1.min(bd2);
    }
}

