/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.wrangler.api.Executor;
import io.cdap.wrangler.api.annotations.Usage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsageRegistry
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(UsageRegistry.class);
    private final Map<String, UsageEntry> usages = new HashMap<String, UsageEntry>();
    private final List<UsageEntry> usageList = new ArrayList<UsageEntry>();

    public UsageRegistry() {
        this.addDefaultDirectives();
    }

    public void addUsage(Class<? extends Executor> classz) {
        Name name = classz.getAnnotation(Name.class);
        Description description = classz.getAnnotation(Description.class);
        Usage usage = classz.getAnnotation(Usage.class);
        if (usage == null || name == null || description == null) {
            return;
        }
        this.usages.put(name.value(), new UsageEntry(name.value(), usage.value(), description.value()));
        this.usageList.add(new UsageEntry(name.value(), usage.value(), description.value()));
    }

    public String getUsage(String directive) {
        if (this.usages.containsKey(directive)) {
            return this.usages.get(directive).getUsage();
        }
        return null;
    }

    public String getDescription(String directive) {
        if (this.usages.containsKey(directive)) {
            return this.usages.get(directive).getDescription();
        }
        return null;
    }

    public List<UsageEntry> getAll() {
        return this.usageList;
    }

    private void addUsage(String directive, String usage, String description) {
        UsageEntry d = new UsageEntry(directive, usage, description);
        this.usages.put(directive, d);
        this.usageList.add(d);
    }

    private void addDefaultDirectives() {
        Reflections reflections = new Reflections("io.cdap.wrangler", new Scanner[0]);
        Set steps = reflections.getSubTypesOf(Executor.class);
        for (Class step : steps) {
            this.addUsage(step);
        }
        this.addUsage("set format", "set format csv <delimiter> <skip empty lines>", "[DEPRECATED] Parses the predefined column as CSV. Use 'parse-as-csv' instead.");
        this.addUsage("format-unix-timestamp", "format-unix-timestamp <column> <format>", "Formats a UNIX timestamp using the specified format");
        this.addUsage("filter-row-if-not-matched", "filter-row-if-not-matched <column> <regex>", "Filters rows if the regex does not match");
        this.addUsage("filter-row-if-false", "filter-row-if-false <condition>", "Filters rows if the condition evaluates to false");
    }

    public class UsageEntry {
        private final String directive;
        private final String usage;
        private final String description;

        public UsageEntry(String directive, String usage, String description) {
            this.directive = directive;
            this.usage = usage;
            this.description = description;
        }

        public String getDirective() {
            return this.directive;
        }

        public String getUsage() {
            return this.usage;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

