/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.executor;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveNotFoundException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRecord;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.Executor;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.RecipePipeline;
import io.cdap.wrangler.api.ReportErrorAndProceed;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.TransientVariableScope;
import io.cdap.wrangler.executor.ErrorRecordCollector;
import io.cdap.wrangler.utils.RecordConvertor;
import io.cdap.wrangler.utils.RecordConvertorException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecipePipelineExecutor
implements RecipePipeline<Row, StructuredRecord, ErrorRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RecipePipelineExecutor.class);
    private final ErrorRecordCollector collector = new ErrorRecordCollector();
    private final RecordConvertor convertor = new RecordConvertor();
    private final RecipeParser recipeParser;
    private final ExecutorContext context;
    private List<Directive> directives;

    public RecipePipelineExecutor(RecipeParser recipeParser, @Nullable ExecutorContext context) {
        this.context = context;
        this.recipeParser = recipeParser;
    }

    public void close() {
        if (this.directives == null) {
            return;
        }
        for (Directive directive : this.directives) {
            try {
                directive.destroy();
            }
            catch (Throwable t) {
                LOG.warn(t.getMessage(), t);
            }
        }
    }

    public List<StructuredRecord> execute(List<Row> rows, Schema schema) throws RecipeException {
        try {
            return this.convertor.toStructureRecord(this.execute(rows), schema);
        }
        catch (RecordConvertorException e) {
            throw new RecipeException("Problem converting into output record. Reason : " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Row> execute(List<Row> rows) throws RecipeException {
        List<Directive> directives = this.getDirectives();
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<Row> results = new ArrayList<Row>();
        try {
            this.collector.reset();
            for (int i = 0; i < rows.size(); ++i) {
                messages.clear();
                if (this.context != null) {
                    this.context.getTransientStore().reset(TransientVariableScope.LOCAL);
                }
                ArrayList cumulativeRows = rows.subList(i, i + 1);
                try {
                    for (Executor executor : directives) {
                        try {
                            if ((cumulativeRows = (ArrayList)executor.execute(cumulativeRows, this.context)).size() >= 1) continue;
                        }
                        catch (ReportErrorAndProceed e) {
                            messages.add(String.format("%s (ecode: %d)", e.getMessage(), e.getCode()));
                            this.collector.add(new ErrorRecord(rows.subList(i, i + 1).get(0), String.join((CharSequence)",", messages), e.getCode(), true));
                            cumulativeRows = new ArrayList();
                        }
                        break;
                    }
                    results.addAll(cumulativeRows);
                    continue;
                }
                catch (ErrorRowException e) {
                    LOG.debug("Error while applying directives", (Throwable)e);
                    messages.add(String.format("%s", e.getMessage()));
                    this.collector.add(new ErrorRecord(rows.subList(i, i + 1).get(0), String.join((CharSequence)",", messages), e.getCode(), e.isShownInWrangler()));
                }
            }
        }
        catch (DirectiveExecutionException e) {
            throw new RecipeException(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List<ErrorRecord> errors() {
        return this.collector.get();
    }

    private List<Directive> getDirectives() throws RecipeException {
        if (this.directives == null) {
            try {
                this.directives = this.recipeParser.parse();
            }
            catch (DirectiveLoadException | DirectiveNotFoundException | DirectiveParseException e) {
                throw new RecipeException(e.getMessage(), e);
            }
        }
        return this.directives;
    }
}

