/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.executor;

import io.cdap.directives.lookup.StaticCatalog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public final class ICDCatalog
implements StaticCatalog {
    private final String name;
    private Map<String, ICDCode> lookupTable = new HashMap<String, ICDCode>();

    public ICDCatalog(String name) {
        this.name = name;
    }

    @Override
    public boolean configure() {
        String filename = String.format("%s_cm_codes.txt", this.name);
        InputStream in = ICDCatalog.class.getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            return false;
        }
        InputStreamReader isr = new InputStreamReader(in);
        try (BufferedReader reader = new BufferedReader(isr);){
            String line;
            while ((line = reader.readLine()) != null) {
                String code = line.substring(0, 7).trim();
                String description = line.substring(8).trim();
                this.lookupTable.put(code, new ICDCode(description));
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public StaticCatalog.Entry lookup(String code) {
        return this.lookupTable.get(code);
    }

    @Override
    public String getCatalog() {
        return this.name;
    }

    public class ICDCode
    implements StaticCatalog.Entry {
        String description;

        ICDCode(String description) {
            this.description = description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

