/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ConvertString {
    public static final String[] WHITESPACE_CHARS = new String[]{"\t", "\n", "\u000b", "\f", "\r", " ", "\u0085", "\u00a0", "\u1680", "\u180e", "\u2000", "\u2001", "\u2002", "\u2003", "\u2004", "\u2005", "\u2006", "\u2007", "\u2008", "\u2009", "\u200a", "\u2028", "\u2029", "\u202f", "\u205f", "\u3000"};
    private String repeatChar = null;
    private Pattern removeRepeatCharPattern = null;
    private Pattern removeWhiteSpacesPattern = null;

    public ConvertString() {
        this(null);
    }

    public ConvertString(String repeatStr) {
        this.repeatChar = repeatStr;
        if (!StringUtils.isEmpty((CharSequence)repeatStr)) {
            this.removeRepeatCharPattern = Pattern.compile("(" + repeatStr + ")+");
        }
        this.removeWhiteSpacesPattern = Pattern.compile("([\\s\\u0085\\p{Z}])\\1+");
    }

    public String removeTrailingAndLeadingWhitespaces(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        String result = input;
        while (StringUtils.startsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeStart((String)result, (String)result.substring(0, 1));
        }
        while (StringUtils.endsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeEnd((String)result, (String)result.substring(result.length() - 1, result.length()));
        }
        return result;
    }

    public String removeTrailingAndLeading(String input) {
        return this.removeTrailingAndLeading(input, " ");
    }

    public String removeTrailingAndLeading(String input, String character) {
        if (StringUtils.isEmpty((CharSequence)input) || StringUtils.isEmpty((CharSequence)character)) {
            return input;
        }
        String result = input;
        while (result.startsWith(character)) {
            result = StringUtils.removeStart((String)result, (String)character);
        }
        while (result.endsWith(character)) {
            result = StringUtils.removeEnd((String)result, (String)character);
        }
        return result;
    }

    public String removeRepeatedChar(String input) {
        if (StringUtils.isEmpty((CharSequence)input) || StringUtils.isEmpty((CharSequence)this.repeatChar) || this.removeRepeatCharPattern == null) {
            return input;
        }
        Matcher matcher = this.removeRepeatCharPattern.matcher(input);
        return matcher.replaceAll(this.repeatChar);
    }

    public String removeRepeatedWhitespaces(String input) {
        if (StringUtils.isEmpty((CharSequence)input) || this.removeWhiteSpacesPattern == null) {
            return input;
        }
        Matcher matcher = this.removeWhiteSpacesPattern.matcher(input);
        return matcher.replaceAll("$1");
    }
}

