/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import org.apache.commons.lang3.StringUtils;

public final class Trimmer {
    public static final String[] WHITESPACE_CHARS = new String[]{"\t", "\n", "\u000b", "\f", "\r", " ", "\u0085", "\u00a0", "\u1680", "\u180e", "\u2000", "\u2001", "\u2002", "\u2003", "\u2004", "\u2005", "\u2006", "\u2007", "\u2008", "\u2009", "\u200a", "\u2028", "\u2029", "\u202f", "\u205f", "\u3000"};

    public static String trim(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        String result = input;
        while (StringUtils.startsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeStart((String)result, (String)result.substring(0, 1));
        }
        while (StringUtils.endsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeEnd((String)result, (String)result.substring(result.length() - 1, result.length()));
        }
        return result;
    }

    public static String ltrim(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        String result = input;
        while (StringUtils.startsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeStart((String)result, (String)result.substring(0, 1));
        }
        return result;
    }

    public static String rtrim(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        String result = input;
        while (StringUtils.endsWithAny((CharSequence)result, (CharSequence[])WHITESPACE_CHARS)) {
            result = StringUtils.removeEnd((String)result, (String)result.substring(result.length() - 1, result.length()));
        }
        return result;
    }
}

