/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import org.apache.commons.lang.WordUtils;

@Plugin(type="directive")
@Name(value="titlecase")
@Categories(categories={"transform"})
@Description(value="Changes the column values to title case.")
public class TitleCase
implements Directive,
Lineage {
    public static final String NAME = "titlecase";
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || !((object = row.getValue(idx)) instanceof String) || object == null) continue;
            String value = (String)object;
            row.setValue(idx, (Object)WordUtils.capitalizeFully((String)value));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Capitalized first letter of the word in the title, heading or headline specified in column '%s'", new Object[]{this.column}).relation(this.column, this.column).build();
    }
}

