/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Bool;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Set;

@Plugin(type="directive")
@Name(value="hash")
@Categories(categories={"transform", "hash"})
@Description(value="Creates a message digest for the column using algorithm, replacing the column value.")
public class MessageHash
implements Directive,
Lineage {
    public static final String NAME = "hash";
    private static final Set<String> algorithms = ImmutableSet.of((Object)"BLAKE2B-160", (Object)"BLAKE2B-256", (Object)"BLAKE2B-384", (Object)"BLAKE2B-512", (Object)"GOST3411-2012-256", (Object)"GOST3411-2012-512", (Object[])new String[]{"GOST3411", "KECCAK-224", "KECCAK-256", "KECCAK-288", "KECCAK-384", "KECCAK-512", "MD2", "MD2", "MD4", "MD5", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512", "SHA-512/224", "SHA-512/256", "SHA", "SHA3-224", "SHA3-256", "SHA3-384", "SHA3-512", "Skein-1024-1024", "Skein-1024-384", "Skein-1024-512", "Skein-256-128", "Skein-256-160", "Skein-256-224", "Skein-256-256", "Skein-512-128", "Skein-512-160", "Skein-512-224", "Skein-512-256", "Skein-512-384", "Skein-512-512", "SM3", "Tiger", "TIGER", "WHIRLPOOL"});
    private String column;
    private boolean encode;
    private MessageDigest digest;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("algorithm", TokenType.TEXT);
        builder.define("encode", TokenType.BOOLEAN, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        Text algorithm = (Text)args.value("algorithm");
        if (!MessageHash.isValid(algorithm.value())) {
            throw new DirectiveParseException(NAME, String.format("Algorithm '%s' specified at line %d is not supported.", algorithm, args.line()));
        }
        try {
            this.digest = MessageDigest.getInstance(algorithm.value());
        }
        catch (NoSuchAlgorithmException e) {
            throw new DirectiveParseException(NAME, String.format("Unable to find algorithm '%s' specified at line %d.", algorithm, args.line()));
        }
        this.encode = false;
        if (args.contains("encode")) {
            this.encode = ((Bool)args.value("encode")).value();
        }
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Anonymized the column '%s'", new Object[]{this.column}).relation(this.column, this.column).build();
    }

    public static boolean isValid(String algorithm) {
        return algorithm != null && algorithms.contains(algorithm);
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                byte[] message;
                Object object = row.getValue(idx);
                if (object == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String' or 'byte array'.", this.column));
                }
                if (object instanceof String) {
                    message = ((String)object).getBytes(StandardCharsets.UTF_8);
                } else if (object instanceof byte[]) {
                    message = (byte[])object;
                } else {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String' or 'byte array'.", this.column, object.getClass().getSimpleName()));
                }
                this.digest.update(message);
                byte[] hashed = this.digest.digest();
                if (this.encode) {
                    String hasedHex = String.format("%064x", new BigInteger(1, hashed));
                    row.addOrSet(this.column, (Object)hasedHex);
                    continue;
                }
                row.addOrSet(this.column, (Object)hashed);
                continue;
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.column));
        }
        return rows;
    }
}

