/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import java.util.Random;
import java.util.UUID;

@Plugin(type="directive")
@Name(value="generate-uuid")
@Categories(categories={"transform", "uuid"})
@Description(value="Populates a column with a universally unique identifier (UUID) of the record.")
public class GenerateUUID
implements Directive,
Lineage {
    public static final String NAME = "generate-uuid";
    private String column;
    private Random random;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.random = new Random();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            UUID uuid = UUID.randomUUID();
            if (idx != -1) {
                row.setValue(idx, (Object)uuid.toString());
                continue;
            }
            row.add(this.column, (Object)uuid.toString());
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Generated unique identifier based on column '%s'", new Object[]{this.column}).relation(this.column, this.column).build();
    }
}

