/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

@Plugin(type="directive")
@Name(value="encode")
@Categories(categories={"transform"})
@Description(value="Encodes column values using one of base32, base64, or hex.")
public class Encode
implements Directive,
Lineage {
    public static final String NAME = "encode";
    private final Base64 base64Encode = new Base64();
    private final Base32 base32Encode = new Base32();
    private final Hex hexEncode = new Hex();
    private Method method;
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("method", TokenType.TEXT);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        String value = ((Text)args.value("method")).value();
        if (!((value = value.toUpperCase()).equals("BASE64") || value.equals("BASE32") || value.equals("HEX"))) {
            throw new DirectiveParseException(NAME, String.format("Type of encoding specified '%s' is not supported. Supported types are base64, base32 & hex.", value));
        }
        this.method = Method.valueOf(value);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || (object = row.getValue(idx)) == null) continue;
            byte[] value = new byte[]{};
            if (object instanceof String) {
                value = ((String)object).getBytes();
            } else if (object instanceof byte[]) {
                value = (byte[])object;
            } else {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String' or 'byte array'.", this.column, object.getClass().getSimpleName()));
            }
            byte[] out = new byte[]{};
            if (this.method == Method.BASE32) {
                out = this.base32Encode.encode(value);
            } else if (this.method == Method.BASE64) {
                out = this.base64Encode.encode(value);
            } else if (this.method == Method.HEX) {
                out = this.hexEncode.encode(value);
            } else {
                throw new DirectiveExecutionException(NAME, String.format("Specified encoding type '%s' is not supported. Supported types are base64, base32 & hex.", this.method.toString()));
            }
            String obj = new String(out, StandardCharsets.UTF_8);
            row.addOrSet(String.format("%s_encode_%s", this.column, this.method.toString().toLowerCase(Locale.ENGLISH)), (Object)obj);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Encoded column '%s' using method '%s'", new Object[]{this.column, this.method.getType()}).relation(this.column, this.column).build();
    }

    public static enum Method {
        BASE64("BASE64"),
        BASE32("BASE32"),
        HEX("HEX");

        private String type;

        private Method(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }
    }
}

