/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="split-to-rows")
@Categories(categories={"row"})
@Description(value="Splits a column into multiple rows, copies the rest of the columns.")
public class SplitToRows
implements Directive,
Lineage {
    public static final String NAME = "split-to-rows";
    private String column;
    private String regex;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("regex", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.regex = ((Text)args.value("regex")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object == null) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.column));
            }
            if (object instanceof String) {
                String[] lines;
                for (String line : lines = ((String)object).split(this.regex)) {
                    Row r = new Row(row);
                    r.setValue(idx, (Object)line);
                    results.add(r);
                }
                continue;
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Split column '%s' into multiple rows using expressions '%s'", new Object[]{this.column, this.regex}).relation(Many.columns((String[])new String[]{this.column}), Many.columns((String[])new String[]{this.column})).build();
    }
}

