/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Bool;
import io.cdap.wrangler.api.parser.Expression;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.expression.EL;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="filter-row")
@Categories(categories={"row", "data-quality"})
@Description(value="Filters rows based on condition type specified.")
public class RecordConditionFilter
implements Directive,
Lineage {
    public static final String NAME = "filter-row";
    private EL el;
    private boolean isTrue;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("condition", TokenType.EXPRESSION);
        builder.define("type", TokenType.BOOLEAN, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.isTrue = true;
        if (args.contains("type")) {
            this.isTrue = ((Bool)args.value("type")).value();
        }
        String condition = ((Expression)args.value("condition")).value();
        try {
            this.el = EL.compile(condition);
        }
        catch (ELException e) {
            throw new DirectiveParseException(NAME, e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            ELContext ctx = new ELContext(context, this.el, row);
            if (context != null) {
                for (String variable : context.getTransientStore().getVariables()) {
                    ctx.set(variable, context.getTransientStore().get(variable));
                }
            }
            try {
                Boolean result = this.el.execute(ctx).getBoolean();
                if (!this.isTrue) {
                    result = result == false;
                }
                if (result.booleanValue()) {
                    continue;
                }
            }
            catch (ELException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable("Filtered records based on columns '%s'", new Object[]{this.el.variables()});
        this.el.variables().forEach(column -> builder.relation(column, column));
        return builder.build();
    }
}

