/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Plugin(type="directive")
@Name(value="flatten")
@Categories(categories={"row"})
@Description(value="Separates array elements of one or more columns into individual records, copying the other columns.")
public class Flatten
implements Directive,
Lineage {
    public static final String NAME = "flatten";
    private String[] columns;
    private int[] locations;
    private int count = 0;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        List cols = ((ColumnNameList)args.value("column")).value();
        this.columns = new String[cols.size()];
        this.columns = cols.toArray(this.columns);
        this.locations = new int[this.columns.length];
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            this.count = 0;
            for (String column : this.columns) {
                this.locations[this.count] = row.find(column);
                ++this.count;
            }
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < this.count; ++i) {
                if (this.locations[i] == -1) continue;
                Object value = row.getValue(this.locations[i]);
                int m = -1;
                m = value instanceof JsonArray ? ((JsonArray)value).size() : (value instanceof List ? ((List)value).size() : 1);
                if (m <= max) continue;
                max = m;
            }
            if (max == 0) {
                results.add(new Row(row));
                continue;
            }
            for (int k = 0; k < max; ++k) {
                Row r = new Row(row);
                for (int i = 0; i < this.count; ++i) {
                    if (this.locations[i] != -1) {
                        Object array;
                        Object value = row.getValue(this.locations[i]);
                        if (value == null) {
                            r.add(this.columns[i], null);
                            continue;
                        }
                        Object v = null;
                        if (value instanceof JsonArray) {
                            array = (JsonArray)value;
                            if (k < array.size()) {
                                v = array.get(k);
                            }
                        } else if (value instanceof List) {
                            array = (List)value;
                            if (k < array.size()) {
                                v = array.get(k);
                            }
                        } else {
                            v = value;
                        }
                        if (v == null) {
                            r.addOrSet(this.columns[i], null);
                            continue;
                        }
                        if (v instanceof JsonElement) {
                            r.setValue(this.locations[i], JsParser.getValue((JsonElement)v));
                            continue;
                        }
                        r.setValue(this.locations[i], v);
                        continue;
                    }
                    r.addOrSet(this.columns[i], null);
                }
                results.add(r);
            }
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Expanded to individual records based on values in columns '%s''", Arrays.asList(this.columns)).all(Many.columns((String[])this.columns), Many.columns((String[])this.columns)).build();
    }
}

