/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@Plugin(type="directive")
@Name(value="parse-timestamp")
@Categories(categories={"parser", "date"})
@Description(value="Parses column values representing unix timestamp as date.")
public class ParseTimestamp
implements Directive,
Lineage {
    public static final String NAME = "parse-timestamp";
    private static final Set<TimeUnit> SUPPORTED_TIME_UNITS = EnumSet.of(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS);
    private String column;
    private TimeUnit timeUnit;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("timeunit", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.timeUnit = TimeUnit.MILLISECONDS;
        if (args.contains("timeunit")) {
            String unitValue = ((Text)args.value("timeunit")).value();
            this.timeUnit = ParseTimestamp.getTimeUnit(unitValue);
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || (object = row.getValue(idx)) == null || object instanceof ZonedDateTime) continue;
            long longValue = this.getLongValue(object);
            ZonedDateTime zonedDateTime = this.getZonedDateTime(longValue, this.timeUnit, ZoneId.ofOffset("UTC", ZoneOffset.UTC));
            row.setValue(idx, (Object)zonedDateTime);
        }
        return rows;
    }

    private static TimeUnit getTimeUnit(String unitValue) throws DirectiveParseException {
        TimeUnit unit;
        try {
            unit = TimeUnit.valueOf(unitValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new DirectiveParseException(NAME, String.format("Time unit '%s' is not a supported time unit. Supported time units are %s", unitValue, SUPPORTED_TIME_UNITS), (Throwable)e);
        }
        if (!SUPPORTED_TIME_UNITS.contains((Object)unit)) {
            throw new DirectiveParseException(NAME, String.format("Time unit '%s' is not a supported time unit. Supported time units are %s", unitValue, SUPPORTED_TIME_UNITS));
        }
        return unit;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as a timestamp using time unit as '%s'", new Object[]{this.column, this.timeUnit}).relation(this.column, this.column).build();
    }

    private long getLongValue(Object object) throws ErrorRowException {
        String errorMsg = String.format("Invalid type '%s' of column '%s'. Must be of type 'Long' or 'String'.", object.getClass().getSimpleName(), this.column);
        try {
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                return Long.parseLong((String)object);
            }
        }
        catch (Exception e) {
            errorMsg = String.format("Invalid value for column '%s'. Must be of type 'Long' or 'String' representing long.", this.column);
        }
        throw new ErrorRowException(NAME, errorMsg, 2);
    }

    private ZonedDateTime getZonedDateTime(long ts, TimeUnit unit, ZoneId zoneId) {
        long mod = unit.convert(1L, TimeUnit.SECONDS);
        int fraction = (int)(ts % mod);
        long tsInSeconds = unit.toSeconds(ts);
        Instant instant = Instant.ofEpochSecond(tsInSeconds, unit.toNanos(fraction));
        return ZonedDateTime.ofInstant(instant, zoneId);
    }
}

