/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import com.google.common.io.Closeables;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.functions.Types;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="directive")
@Name(value="parse-as-excel")
@Categories(categories={"parser", "excel"})
@Description(value="Parses column as Excel file.")
public class ParseExcel
implements Directive,
Lineage {
    public static final String NAME = "parse-as-excel";
    private static final Logger LOG = LoggerFactory.getLogger(ParseExcel.class);
    private String column;
    private String sheet;
    private boolean firstRowAsHeader = false;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("sheet", TokenType.TEXT, true);
        builder.define("first-row-as-header", TokenType.BOOLEAN, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.sheet = args.contains("sheet") ? ((Text)args.value("sheet")).value() : "0";
        if (args.contains("first-row-as-header")) {
            this.firstRowAsHeader = (Boolean)args.value("first-row-as-header").value();
        }
    }

    public void destroy() {
    }

    public List<io.cdap.wrangler.api.Row> execute(List<io.cdap.wrangler.api.Row> records, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        ArrayList<io.cdap.wrangler.api.Row> results = new ArrayList<io.cdap.wrangler.api.Row>();
        ByteArrayInputStream input = null;
        try {
            for (io.cdap.wrangler.api.Row record : records) {
                int idx = record.find(this.column);
                if (idx == -1) continue;
                Object object = record.getValue(idx);
                byte[] bytes = null;
                if (object instanceof byte[]) {
                    bytes = (byte[])object;
                } else if (object instanceof ByteBuffer) {
                    ByteBuffer buffer = (ByteBuffer)object;
                    bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                } else {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' should be of type 'byte array' or 'ByteBuffer'.", this.column));
                }
                if (bytes == null) continue;
                input = new ByteArrayInputStream(bytes);
                XSSFWorkbook book = new XSSFWorkbook((InputStream)input);
                XSSFSheet excelsheet = Types.isInteger(this.sheet) ? book.getSheetAt(Integer.parseInt(this.sheet)) : book.getSheet(this.sheet);
                if (excelsheet == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Failed to extract sheet '%s' from the excel. Sheet '%s' does not exist.", this.sheet, this.sheet));
                }
                TreeMap<Integer, String> columnNames = new TreeMap<Integer, String>();
                Iterator it = excelsheet.iterator();
                int rows = 0;
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Iterator cellIterator = row.cellIterator();
                    if (this.checkIfRowIsEmpty(row)) continue;
                    io.cdap.wrangler.api.Row newRow = new io.cdap.wrangler.api.Row();
                    newRow.add("fwd", (Object)rows);
                    while (cellIterator.hasNext()) {
                        String value;
                        Cell cell = (Cell)cellIterator.next();
                        String name = this.columnName(cell.getAddress().getColumn());
                        if (this.firstRowAsHeader && rows > 0 && (value = (String)columnNames.get(cell.getAddress().getColumn())) != null) {
                            name = value;
                        }
                        value = "";
                        switch (cell.getCellTypeEnum()) {
                            case STRING: {
                                newRow.add(name, (Object)cell.getStringCellValue());
                                value = cell.getStringCellValue();
                                break;
                            }
                            case NUMERIC: {
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    newRow.add(name, (Object)cell.getDateCellValue());
                                    value = cell.getDateCellValue().toString();
                                    break;
                                }
                                newRow.add(name, (Object)cell.getNumericCellValue());
                                value = String.valueOf(cell.getNumericCellValue());
                                break;
                            }
                            case BOOLEAN: {
                                newRow.add(name, (Object)cell.getBooleanCellValue());
                                value = String.valueOf(cell.getBooleanCellValue());
                            }
                        }
                        if (rows != 0 || !this.firstRowAsHeader) continue;
                        columnNames.put(cell.getAddress().getColumn(), value);
                    }
                    if (this.firstRowAsHeader && rows == 0) {
                        ++rows;
                        continue;
                    }
                    for (Pair field : record.getFields()) {
                        String colName = (String)field.getFirst();
                        if (newRow.getValue(colName) != null || colName.equals(this.column)) continue;
                        newRow.add(colName, field.getSecond());
                    }
                    results.add(newRow);
                    ++rows;
                }
                if (this.firstRowAsHeader) {
                    --rows;
                }
                for (int i = rows - 1; i >= 0; --i) {
                    ((io.cdap.wrangler.api.Row)results.get(rows - i - 1)).addOrSetAtIndex(1, "bkd", (Object)i);
                }
            }
        }
        catch (Exception e) {
            throw new ErrorRowException(NAME, e.getMessage(), 1);
        }
        finally {
            if (input != null) {
                Closeables.closeQuietly(input);
            }
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as a Excel", new Object[]{this.column}).all(Many.columns((String[])new String[]{this.column})).build();
    }

    private boolean checkIfRowIsEmpty(Row row) {
        if (row == null) {
            return true;
        }
        if (row.getLastCellNum() <= 0) {
            return true;
        }
        for (int cellNum = row.getFirstCellNum(); cellNum < row.getLastCellNum(); ++cellNum) {
            Cell cell = row.getCell(cellNum);
            if (cell == null || cell.getCellTypeEnum() == CellType.BLANK || !StringUtils.isNotBlank((CharSequence)cell.toString())) continue;
            return false;
        }
        return true;
    }

    private String columnName(int number) {
        StringBuilder sb = new StringBuilder();
        int num = number;
        while (num >= 0) {
            int numChar = num % 26 + 65;
            sb.append((char)numChar);
            num = num / 26 - 1;
        }
        return sb.reverse().toString();
    }
}

