/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="json-path")
@Categories(categories={"parser", "json"})
@Description(value="Parses JSON elements using a DSL (a JSON path expression).")
public class JsPath
implements Directive,
Lineage {
    public static final String NAME = "json-path";
    private String src;
    private String dest;
    private String path;
    private ParseContext parser;
    public static final Configuration GSON_CONFIGURATION = Configuration.builder().mappingProvider((MappingProvider)new GsonMappingProvider()).jsonProvider((JsonProvider)new GsonJsonProvider()).build();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define(NAME, TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.src = ((ColumnName)args.value("source")).value();
        this.dest = ((ColumnName)args.value("destination")).value();
        this.path = ((Text)args.value(NAME)).value();
        this.parser = JsonPath.using((Configuration)GSON_CONFIGURATION);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            Object value = row.getValue(this.src);
            if (value == null) {
                row.add(this.dest, null);
                continue;
            }
            if (!(value instanceof String || value instanceof JsonObject || value instanceof JsonArray)) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'String' or 'JsonObject' or 'JsonArray'.", this.src, value.getClass().getSimpleName()));
            }
            JsonElement element = (JsonElement)this.parser.parse(value).read(this.path, new Predicate[0]);
            Object val = JsParser.getValue(element);
            int pos = row.find(this.dest);
            if (pos == -1) {
                row.add(this.dest, val);
            } else {
                row.setValue(pos, val);
            }
            results.add(row);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Extracted value from column '%s' represented as Json to destination column '%s' using path '%s'", new Object[]{this.src, this.dest, this.path}).conditional(this.src, this.dest).build();
    }
}

