/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.datamodel;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.datamodel.HTTPSchemaLoader;
import io.cdap.wrangler.utils.AvroSchemaGlossary;
import io.cdap.wrangler.utils.ColumnConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;

@Plugin(type="directive")
@Name(value="data-model-map-column")
@Categories(categories={"data-quality"})
@Description(value="Maps a column to target data model field so that matches the target name and type.")
public class DataModelMapColumn
implements Directive,
Lineage {
    public static final String NAME = "data-model-map-column";
    private static final String DATA_MODEL = "data-model";
    private static final String DATA_MODEL_REVISION = "revision";
    private static final String MODEL = "model";
    private static final String TARGET_FIELD = "target-field";
    private static final String COLUMN = "column";
    private static final String DATA_MODEL_URL = "data-model-url";
    private static Map<String, AvroSchemaGlossary> glossaryCache = new HashMap<String, AvroSchemaGlossary>();
    private String column;
    private String targetFieldName;
    private String targetFieldTypeName;

    static void setGlossary(String key, AvroSchemaGlossary glossary) {
        glossaryCache.put(key, glossary);
    }

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(DATA_MODEL_URL, TokenType.TEXT);
        builder.define(DATA_MODEL, TokenType.TEXT);
        builder.define(DATA_MODEL_REVISION, TokenType.NUMERIC);
        builder.define(MODEL, TokenType.TEXT);
        builder.define(TARGET_FIELD, TokenType.TEXT);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void destroy() {
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        String dataModelUrl = ((Text)args.value(DATA_MODEL_URL)).value();
        if (!glossaryCache.containsKey(dataModelUrl)) {
            AvroSchemaGlossary glossary = new AvroSchemaGlossary(new HTTPSchemaLoader(dataModelUrl, "manifest.json"));
            if (!glossary.configure()) {
                throw new DirectiveParseException(NAME, String.format("Unable to load data models from %s.", dataModelUrl));
            }
            glossaryCache.put(dataModelUrl, glossary);
        }
        String dataModelName = ((Text)args.value(DATA_MODEL)).value();
        long revision = ((Numeric)args.value(DATA_MODEL_REVISION)).value().longValue();
        Schema dataModel = glossaryCache.get(dataModelUrl).get(dataModelName, revision);
        if (dataModel == null) {
            throw new DirectiveParseException(NAME, String.format("Unable to find data model %s revision %d.", dataModelName, revision));
        }
        String modelName = ((Text)args.value(MODEL)).value();
        Schema.Field modelField = dataModel.getField(modelName);
        if (modelField == null) {
            throw new DirectiveParseException(NAME, String.format("Model %s does not exist in data model %s.", modelName, dataModelName));
        }
        Schema subSchema = modelField.schema();
        if (subSchema == null) {
            throw new DirectiveParseException(NAME, String.format("Model %s has no schema.", modelField.name()));
        }
        Schema model = subSchema.getTypes().stream().filter(s -> s.getType() == Schema.Type.RECORD).findFirst().orElse(null);
        if (model == null) {
            throw new DirectiveParseException(NAME, String.format("Model %s has no schema.", subSchema.getName()));
        }
        String targetName = ((Text)args.value(TARGET_FIELD)).value();
        Schema.Field targetField = model.getField(targetName);
        if (targetField == null) {
            throw new DirectiveParseException(NAME, String.format("Field %s does not exist in model %s.", targetName, model.getName()));
        }
        Schema type = targetField.schema().getTypes().stream().filter(s -> s.getType() != Schema.Type.NULL).findFirst().orElse(null);
        if (type == null) {
            throw new DirectiveParseException(NAME, String.format(" Field %s of model %s in data model %s is missing type information.", targetField.name(), modelName, dataModelName));
        }
        this.targetFieldName = targetField.name();
        this.targetFieldTypeName = type.getName();
        this.column = ((ColumnName)args.value(COLUMN)).value();
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ColumnConverter.convertType(NAME, row, this.column, this.targetFieldTypeName);
            ColumnConverter.rename(NAME, row, this.column, this.targetFieldName);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Mapped column '%s' to column name '%s' and type '%s'", new Object[]{this.column, this.targetFieldName, this.targetFieldTypeName}).relation(this.column, this.targetFieldName).build();
    }
}

