/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directives")
@Name(value="set-headers")
@Categories(categories={"column"})
@Description(value="Sets the header of columns, in the order they are specified.")
public class SetHeader
implements Directive,
Lineage {
    public static final String NAME = "set-headers";
    private List<String> columns = new ArrayList<String>();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.columns = ((ColumnNameList)args.value("column")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = 0;
            for (String name : this.columns) {
                if (idx < row.width()) {
                    row.setColumn(idx, name.trim());
                }
                ++idx;
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Set the new header as columns '%s'", new Object[]{this.columns}).generate(Many.of(this.columns)).build();
    }
}

