/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.utils.ColumnConverter;
import java.util.List;

@Plugin(type="directive")
@Name(value="rename")
@Categories(categories={"column"})
@Description(value="Renames a column 'source' to 'target'")
public final class Rename
implements Directive,
Lineage {
    public static final String NAME = "rename";
    private ColumnName source;
    private ColumnName target;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("target", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) {
        this.source = (ColumnName)args.value("source");
        if (args.contains("target")) {
            this.target = (ColumnName)args.value("target");
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ColumnConverter.rename(NAME, row, this.source.value(), this.target.value());
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Renamed column '%s' to '%s'", new Object[]{this.source.value(), this.target.value()}).relation(this.source, this.target).build();
    }
}

