/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="copy")
@Categories(categories={"column"})
@Description(value="Copies values from a source column into a destination column.")
public class Copy
implements Directive,
Lineage {
    public static final String NAME = "copy";
    private ColumnName source;
    private ColumnName destination;
    private boolean force = false;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("force", TokenType.BOOLEAN, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.source = (ColumnName)args.value("source");
        this.destination = (ColumnName)args.value("destination");
        if (args.contains("force")) {
            this.force = (Boolean)args.value("force").value();
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int sidx = row.find(this.source.value());
            if (sidx == -1) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.source.value()));
            }
            int didx = row.find(this.destination.value());
            if (didx == sidx) continue;
            if (didx == -1) {
                row.add(this.destination.value(), row.getValue(sidx));
                continue;
            }
            if (!this.force) {
                throw new DirectiveExecutionException(NAME, String.format("Destination column '%s' already exists in the row. Use 'force' option to overwrite the column.", this.destination.value()));
            }
            row.setValue(didx, row.getValue(sidx));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Copied value from column '%s' to '%s'", new Object[]{this.source.value(), this.destination.value()}).conditional(this.source.value(), this.destination.value()).build();
    }
}

