/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.validator;

import io.cdap.wrangler.validator.Validator;
import io.cdap.wrangler.validator.ValidatorException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class ColumnNameValidator
implements Validator<String> {
    private static final String RESERVED_WORDS_FILE = "reserved-column-names.txt";
    private final Set<String> reservedWords = new HashSet<String>();

    @Override
    public void initialize() throws Exception {
        InputStream in = ColumnNameValidator.class.getClassLoader().getResourceAsStream(RESERVED_WORDS_FILE);
        if (in == null) {
            throw new Exception("Unable to load 'reserved-column-names.txt' from the resources");
        }
        InputStreamReader isr = new InputStreamReader(in);
        try (BufferedReader reader = new BufferedReader(isr);){
            String word;
            while ((word = reader.readLine()) != null) {
                this.reservedWords.add(word.toLowerCase(Locale.ENGLISH));
            }
        }
    }

    @Override
    public void validate(String name) throws ValidatorException {
        if (!name.matches("^[a-zA-Z0-9_]*$")) {
            throw new ValidatorException("Column '" + name + "' contains non-alphanumeric characters");
        }
        if (this.reservedWords.contains(name)) {
            throw new ValidatorException("Column '" + name + "' is a reserved word.");
        }
        if (name.length() > 255) {
            throw new ValidatorException("Column '" + name + "' is greater than 255 characters.");
        }
    }
}

