/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import java.math.BigDecimal;
import java.math.BigInteger;

public class DecimalTransform {
    public static BigDecimal add(BigDecimal bd1, Object o) {
        BigDecimal bd2 = DecimalTransform.objectToBigDecimal(o);
        if (bd1 == null) {
            return bd2;
        }
        return bd1.add(bd2);
    }

    public static BigDecimal subtract(BigDecimal bd1, Object o) {
        BigDecimal bd2 = DecimalTransform.objectToBigDecimal(o);
        if (bd1 == null) {
            return bd2.negate();
        }
        return bd1.subtract(bd2);
    }

    public static BigDecimal multiply(BigDecimal bd1, Object o) {
        BigDecimal bd2 = DecimalTransform.objectToBigDecimal(o);
        if (bd1 == null) {
            return BigDecimal.ZERO;
        }
        return bd1.multiply(bd2);
    }

    public static BigDecimal divideq(BigDecimal bd1, Object o) {
        BigDecimal bd2 = DecimalTransform.objectToBigDecimal(o);
        if (bd2.equals(BigDecimal.ZERO)) {
            return null;
        }
        if (bd1 == null) {
            return BigDecimal.ZERO;
        }
        return bd1.divide(bd2, 6);
    }

    public static BigDecimal divider(BigDecimal bd1, Object o) {
        BigDecimal bd2 = DecimalTransform.objectToBigDecimal(o);
        if (bd2.equals(BigDecimal.ZERO)) {
            return null;
        }
        if (bd1 == null) {
            return BigDecimal.ZERO;
        }
        return bd1.remainder(bd2);
    }

    public static BigDecimal abs(BigDecimal bd) {
        return bd.abs();
    }

    public static int precision(BigDecimal bd) {
        return bd.precision();
    }

    public static int scale(BigDecimal bd) {
        return bd.scale();
    }

    public static BigInteger unscaled(BigDecimal bd) {
        return bd.unscaledValue();
    }

    public static BigDecimal decimal_left(BigDecimal bd, int n) {
        int newScale = bd.scale() + n;
        bd = bd.setScale(newScale, 0);
        bd = bd.divide(BigDecimal.valueOf(Math.pow(10.0, n)), 6);
        return bd.stripTrailingZeros();
    }

    public static BigDecimal decimal_right(BigDecimal bd, int n) {
        int newScale = Math.max(bd.scale() - n, 0);
        bd = bd.multiply(BigDecimal.valueOf(Math.pow(10.0, n)));
        bd = bd.setScale(newScale, 1);
        return bd;
    }

    public static BigDecimal pow(BigDecimal bd, int pow) {
        return bd.pow(pow);
    }

    public static BigDecimal negate(BigDecimal bd) {
        if ((bd = bd.negate()).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return bd;
    }

    public static BigDecimal strip_zero(BigDecimal bd) {
        return bd.stripTrailingZeros();
    }

    public static int sign(BigDecimal bd) {
        return Integer.compare(bd.compareTo(BigDecimal.ZERO), 0);
    }

    private static BigDecimal objectToBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Integer) {
            return BigDecimal.valueOf(((Integer)o).intValue());
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o);
        }
        return null;
    }
}

