/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.statistics;

import io.cdap.wrangler.api.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class Measurements {
    private final Map<String, MutableDouble> metrics = new TreeMap<String, MutableDouble>();

    public void increment(String name) {
        MutableDouble value = this.metrics.get(name);
        if (value != null) {
            value.increment();
        } else {
            this.metrics.put(name, new MutableDouble(1.0));
        }
    }

    public void set(String name, Double value) {
        this.metrics.put(name, new MutableDouble(value));
    }

    public List<Pair<String, Double>> percentage(Double sum) {
        ArrayList<Pair<String, Double>> percentages = new ArrayList<Pair<String, Double>>();
        for (Map.Entry<String, MutableDouble> entry : this.metrics.entrySet()) {
            double percentage = entry.getValue().get() / sum;
            if (percentage > 100.0) {
                percentage = 100.0;
            }
            percentages.add((Pair<String, Double>)new Pair((Object)entry.getKey(), (Object)percentage));
        }
        return percentages;
    }

    private class MutableDouble {
        private double value = 0.0;

        MutableDouble(double value) {
            this.value = value;
        }

        public void increment() {
            this.value += 1.0;
        }

        public double get() {
            return this.value;
        }
    }
}

