/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.sampling;

import io.cdap.wrangler.api.annotations.Public;
import io.cdap.wrangler.sampling.MathUtils;
import java.util.Random;

@Public
public class XORShiftRNG
extends Random {
    private static final long serialVersionUID = -825722456120842841L;
    private long seed;

    public XORShiftRNG() {
        this(System.nanoTime());
    }

    public XORShiftRNG(long input) {
        super(input);
        this.seed = MathUtils.murmurHash((int)input) ^ MathUtils.murmurHash((int)(input >>> 32));
    }

    @Override
    public int next(int bits) {
        long nextSeed = this.seed ^ this.seed << 21;
        nextSeed ^= nextSeed >>> 35;
        nextSeed ^= nextSeed << 4;
        this.seed = nextSeed;
        return (int)(nextSeed & (1L << bits) - 1L);
    }
}

