/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.sampling;

import com.google.common.base.Preconditions;
import io.cdap.wrangler.sampling.Sampler;
import io.cdap.wrangler.sampling.XORShiftRNG;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Random;

public class Reservoir<T>
extends Sampler<T> {
    private final int numSamples;
    private final Random random;

    public Reservoir(int numSamples, Random random) {
        Preconditions.checkArgument((numSamples >= 0 ? 1 : 0) != 0, (Object)"numSamples should be non-negative.");
        this.numSamples = numSamples;
        this.random = random;
    }

    public Reservoir(int numSamples) {
        this(numSamples, new XORShiftRNG());
    }

    public Reservoir(int numSamples, long seed) {
        this(numSamples, new XORShiftRNG(seed));
    }

    @Override
    public Iterator<T> sample(Iterator<T> input) {
        if (this.numSamples == 0) {
            return this.emptyIterable;
        }
        PriorityQueue<IntermediateSample<T>> queue = new PriorityQueue<IntermediateSample<T>>(this.numSamples);
        int index = 0;
        IntermediateSample smallest = null;
        while (input.hasNext()) {
            T element = input.next();
            if (index < this.numSamples) {
                queue.add(new IntermediateSample<T>(this.random.nextDouble(), element));
                smallest = (IntermediateSample)queue.peek();
            } else {
                double rand = this.random.nextDouble();
                if (rand > smallest.getWeight()) {
                    queue.remove();
                    queue.add(new IntermediateSample<T>(rand, element));
                    smallest = (IntermediateSample)queue.peek();
                }
            }
            ++index;
        }
        final Iterator itr = queue.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public T next() {
                return ((IntermediateSample)itr.next()).getElement();
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public static class IntermediateSample<T>
    implements Comparable<IntermediateSample<T>> {
        private double weight;
        private T element;

        public IntermediateSample(double weight, T element) {
            this.weight = weight;
            this.element = element;
        }

        public double getWeight() {
            return this.weight;
        }

        public T getElement() {
            return this.element;
        }

        @Override
        public int compareTo(IntermediateSample<T> other) {
            return this.weight >= other.getWeight() ? 1 : -1;
        }
    }
}

