/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.sampling;

import com.google.common.base.Preconditions;
import io.cdap.wrangler.sampling.Sampler;
import io.cdap.wrangler.sampling.SamplingIterator;
import io.cdap.wrangler.sampling.XORShiftRNG;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.math3.distribution.PoissonDistribution;

public class Poisson<T>
extends Sampler<T> {
    private PoissonDistribution poissonDistribution;
    private final double fraction;
    private final Random random;
    private static final double THRESHOLD = 0.4;

    public Poisson(double fraction, long seed) {
        Preconditions.checkArgument((fraction >= 0.0 ? 1 : 0) != 0, (Object)"fraction should be positive.");
        this.fraction = fraction;
        if (this.fraction > 0.0) {
            this.poissonDistribution = new PoissonDistribution(fraction);
            this.poissonDistribution.reseedRandomGenerator(seed);
        }
        this.random = new XORShiftRNG(seed);
    }

    public Poisson(double fraction) {
        Preconditions.checkArgument((fraction >= 0.0 ? 1 : 0) != 0, (Object)"fraction should be non-negative.");
        this.fraction = fraction;
        if (this.fraction > 0.0) {
            this.poissonDistribution = new PoissonDistribution(fraction);
        }
        this.random = new XORShiftRNG();
    }

    @Override
    public Iterator<T> sample(final Iterator<T> input) {
        if (this.fraction == 0.0) {
            return this.emptyIterable;
        }
        return new SamplingIterator<T>(){
            T currentElement;
            int currentCount = 0;

            @Override
            public boolean hasNext() {
                if (this.currentCount > 0) {
                    return true;
                }
                this.samplingProcess();
                return this.currentCount > 0;
            }

            @Override
            public T next() {
                if (this.currentCount <= 0) {
                    this.samplingProcess();
                }
                --this.currentCount;
                return this.currentElement;
            }

            public int poisson_ge1(double p) {
                double q = Math.pow(Math.E, -p);
                double t = q + (1.0 - q) * Poisson.this.random.nextDouble();
                int k = 1;
                t *= Poisson.this.random.nextDouble();
                while (t > q) {
                    ++k;
                    t *= Poisson.this.random.nextDouble();
                }
                return k;
            }

            private void skipGapElements(int num) {
                for (int elementCount = 0; input.hasNext() && elementCount < num; ++elementCount) {
                    this.currentElement = input.next();
                }
            }

            private void samplingProcess() {
                block2: {
                    block1: {
                        if (!(Poisson.this.fraction <= 0.4)) break block1;
                        double u = Math.max(Poisson.this.random.nextDouble(), 1.0E-5);
                        int gap = (int)(Math.log(u) / -Poisson.this.fraction);
                        this.skipGapElements(gap);
                        if (!input.hasNext()) break block2;
                        this.currentElement = input.next();
                        this.currentCount = this.poisson_ge1(Poisson.this.fraction);
                        break block2;
                    }
                    while (input.hasNext()) {
                        this.currentElement = input.next();
                        this.currentCount = Poisson.this.poissonDistribution.sample();
                        if (this.currentCount <= 0) continue;
                        break;
                    }
                }
            }
        };
    }
}

