/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import io.cdap.cdap.api.artifact.ArtifactInfo;
import io.cdap.cdap.api.artifact.CloseableClassLoader;
import io.cdap.cdap.api.plugin.PluginClass;
import io.cdap.cdap.api.plugin.PluginConfigurer;
import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.api.service.http.HttpServiceContext;
import io.cdap.cdap.etl.api.StageContext;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nullable;

public final class UserDirectiveRegistry
implements DirectiveRegistry {
    private final Map<String, Map<String, DirectiveInfo>> registry = new ConcurrentSkipListMap<String, Map<String, DirectiveInfo>>();
    private final List<CloseableClassLoader> classLoaders = new ArrayList<CloseableClassLoader>();
    private StageContext context = null;
    private HttpServiceContext manager = null;

    public UserDirectiveRegistry(HttpServiceContext manager) throws DirectiveLoadException {
        this.manager = manager;
    }

    public UserDirectiveRegistry(StageContext context) {
        this.context = context;
    }

    @Override
    @Nullable
    public DirectiveInfo get(String namespace, String name) throws DirectiveLoadException {
        Class directive = null;
        try {
            if (this.context != null) {
                directive = this.context.loadPluginClass(name);
            } else if (this.manager != null) {
                PluginConfigurer configurer = this.manager.createPluginConfigurer(namespace);
                directive = configurer.usePluginClass("directive", name, UUID.randomUUID().toString(), PluginProperties.builder().build());
            }
            if (directive == null) {
                throw new DirectiveLoadException(String.format("10-5 - Unable to load the user defined directive '%s'. Please check if the artifact containing UDD is still present.", name));
            }
            DirectiveInfo directiveInfo = new DirectiveInfo(DirectiveInfo.Scope.USER, directive);
            return directiveInfo;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DirectiveLoadException(e.getMessage(), (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new DirectiveLoadException(String.format("Directive '%s' not found. Check if the directive is spelled correctly or artifact containing the directive has been uploaded or you might be missing '#pragma load-directives %s;'", name, name), (Exception)e);
        }
        catch (Exception e) {
            throw new DirectiveLoadException(e.getMessage(), e);
        }
    }

    @Override
    public void reload(String namespace) throws DirectiveLoadException {
        TreeMap<String, DirectiveInfo> newRegistry = new TreeMap<String, DirectiveInfo>();
        Map currentRegistry = this.registry.computeIfAbsent(namespace, k -> new TreeMap());
        if (this.manager != null) {
            try {
                List artifacts = this.manager.listArtifacts(namespace);
                for (ArtifactInfo artifact : artifacts) {
                    Set plugins = artifact.getClasses().getPlugins();
                    for (PluginClass plugin : plugins) {
                        if (!"directive".equalsIgnoreCase(plugin.getType())) continue;
                        CloseableClassLoader closeableClassLoader = this.manager.createClassLoader(namespace, artifact, this.getClass().getClassLoader());
                        Class directive = closeableClassLoader.loadClass(plugin.getClassName());
                        DirectiveInfo classz = new DirectiveInfo(DirectiveInfo.Scope.USER, directive);
                        newRegistry.put(classz.name(), classz);
                        this.classLoaders.add(closeableClassLoader);
                    }
                }
                MapDifference difference = Maps.difference((Map)currentRegistry, newRegistry);
                for (String directive : difference.entriesOnlyOnLeft().keySet()) {
                    currentRegistry.remove(directive);
                }
                for (String directive : difference.entriesInCommon().keySet()) {
                    currentRegistry.put(directive, difference.entriesInCommon().get(directive));
                }
                for (String directive : difference.entriesOnlyOnRight().keySet()) {
                    currentRegistry.put(directive, difference.entriesOnlyOnRight().get(directive));
                }
            }
            catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new DirectiveLoadException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        Map namespaceDirectives = this.registry.getOrDefault(namespace, Collections.emptyMap());
        return namespaceDirectives.values();
    }

    @Override
    public void close() throws IOException {
        for (CloseableClassLoader classLoader : this.classLoaders) {
            classLoader.close();
        }
    }
}

