/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class SystemDirectiveRegistry
implements DirectiveRegistry {
    private static final String PACKAGE = "io.cdap.directives";
    private final Map<String, DirectiveInfo> registry = new ConcurrentSkipListMap<String, DirectiveInfo>();

    public SystemDirectiveRegistry() throws DirectiveLoadException {
        this(new ArrayList<String>());
    }

    public SystemDirectiveRegistry(List<String> namespaces) throws DirectiveLoadException {
        namespaces.add(PACKAGE);
        for (String namespace : namespaces) {
            try {
                Reflections reflections = new Reflections(namespace, new Scanner[0]);
                Set system = reflections.getSubTypesOf(Directive.class);
                for (Class directive : system) {
                    DirectiveInfo classz = new DirectiveInfo(DirectiveInfo.Scope.SYSTEM, directive);
                    this.registry.put(classz.name(), classz);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new DirectiveLoadException(e.getMessage(), (Exception)e);
            }
        }
    }

    @Override
    public DirectiveInfo get(String namespace, String name) {
        return this.registry.get(name);
    }

    @Override
    public void reload(String namespace) {
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        return this.registry.values();
    }

    @Override
    public void close() {
    }
}

