/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveContext;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.parser.NoOpDirectiveContext;
import io.cdap.wrangler.parser.UsageRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextParser
implements RecipeParser {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTextParser.class);
    private String[] directives;
    private static final UsageRegistry usageRegistry = new UsageRegistry();
    private DirectiveContext context;

    public SimpleTextParser(String[] directives) {
        this.directives = directives;
        this.context = new NoOpDirectiveContext();
    }

    public SimpleTextParser(String directives) {
        this(directives.split("\n"));
    }

    public SimpleTextParser(List<String> directives) {
        this(directives.toArray(new String[directives.size()]));
    }

    public List<Directive> parse() throws DirectiveParseException {
        ArrayList<Directive> directives = new ArrayList<Directive>();
        boolean lineno = true;
        for (String directive : this.directives) {
            if ((directive = directive.trim()).isEmpty() || directive.startsWith("//") || directive.startsWith("#")) continue;
            StringTokenizer tokenizer = new StringTokenizer(directive, " ");
            String command = tokenizer.nextToken();
            String root = command;
            if (this.context.hasAlias(root)) {
                root = this.context.getAlias(command);
            }
            if (!root.equals(command) && this.context.isExcluded(command)) {
                throw new DirectiveParseException(command, String.format("Aliased directive '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
            }
            if (!this.context.isExcluded(root)) continue;
            throw new DirectiveParseException(command, String.format("Executor '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
        }
        return directives;
    }

    public static String getNextToken(StringTokenizer tokenizer, String directive, String field, int lineno) throws DirectiveParseException {
        return SimpleTextParser.getNextToken(tokenizer, null, directive, field, lineno, false);
    }

    public static String getNextToken(StringTokenizer tokenizer, String delimiter, String directive, String field, int lineno) throws DirectiveParseException {
        return SimpleTextParser.getNextToken(tokenizer, delimiter, directive, field, lineno, false);
    }

    public static String getNextToken(StringTokenizer tokenizer, String delimiter, String directive, String field, int lineno, boolean optional) throws DirectiveParseException {
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = delimiter == null ? tokenizer.nextToken().trim() : tokenizer.nextToken(delimiter).trim();
        } else if (!optional) {
            String usage = usageRegistry.getUsage(directive);
            throw new DirectiveParseException(directive, String.format("Missing field '%s' at line number %d (usage: %s)", field, lineno, usage));
        }
        return value;
    }

    public void initialize(DirectiveContext context) {
        this.context = context == null ? new NoOpDirectiveContext() : context;
    }
}

