/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import io.cdap.wrangler.api.LazyNumber;
import io.cdap.wrangler.api.RecipeSymbol;
import io.cdap.wrangler.api.SourceInfo;
import io.cdap.wrangler.api.Triplet;
import io.cdap.wrangler.api.parser.Bool;
import io.cdap.wrangler.api.parser.BoolList;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.DirectiveName;
import io.cdap.wrangler.api.parser.Expression;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.NumericList;
import io.cdap.wrangler.api.parser.Properties;
import io.cdap.wrangler.api.parser.Ranges;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TextList;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.parser.DirectivesBaseVisitor;
import io.cdap.wrangler.parser.DirectivesParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class RecipeVisitor
extends DirectivesBaseVisitor<RecipeSymbol.Builder> {
    private RecipeSymbol.Builder builder = new RecipeSymbol.Builder();

    public RecipeSymbol getCompiledUnit() {
        return this.builder.build();
    }

    @Override
    public RecipeSymbol.Builder visitDirective(DirectivesParser.DirectiveContext ctx) {
        this.builder.createTokenGroup(this.getOriginalSource(ctx));
        return (RecipeSymbol.Builder)super.visitDirective(ctx);
    }

    @Override
    public RecipeSymbol.Builder visitIdentifier(DirectivesParser.IdentifierContext ctx) {
        this.builder.addToken((Token)new Identifier(ctx.Identifier().getText()));
        return (RecipeSymbol.Builder)super.visitIdentifier(ctx);
    }

    @Override
    public RecipeSymbol.Builder visitPropertyList(DirectivesParser.PropertyListContext ctx) {
        HashMap<String, Numeric> props = new HashMap<String, Numeric>();
        List<DirectivesParser.PropertyContext> properties = ctx.property();
        for (DirectivesParser.PropertyContext property : properties) {
            Numeric token;
            String identifier = property.Identifier().getText();
            if (property.number() != null) {
                token = new Numeric(new LazyNumber(property.number().getText()));
            } else if (property.bool() != null) {
                token = new Bool(Boolean.valueOf(property.bool().getText()));
            } else {
                String text = property.text().getText();
                token = new Text(text.substring(1, text.length() - 1));
            }
            props.put(identifier, token);
        }
        this.builder.addToken((Token)new Properties(props));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitPragmaLoadDirective(DirectivesParser.PragmaLoadDirectiveContext ctx) {
        List<TerminalNode> identifiers = ctx.identifierList().Identifier();
        for (TerminalNode identifier : identifiers) {
            this.builder.addLoadableDirective(identifier.getText());
        }
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitPragmaVersion(DirectivesParser.PragmaVersionContext ctx) {
        this.builder.addVersion(ctx.Number().getText());
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitNumberRanges(DirectivesParser.NumberRangesContext ctx) {
        ArrayList<Triplet> output = new ArrayList<Triplet>();
        List<DirectivesParser.NumberRangeContext> ranges = ctx.numberRange();
        for (DirectivesParser.NumberRangeContext range : ranges) {
            List<TerminalNode> numbers = range.Number();
            String text = range.value().getText();
            if (text.startsWith("'") && text.endsWith("'")) {
                text = text.substring(1, text.length() - 1);
            }
            Triplet val = new Triplet((Object)new Numeric(new LazyNumber(numbers.get(0).getText())), (Object)new Numeric(new LazyNumber(numbers.get(1).getText())), (Object)text);
            output.add(val);
        }
        this.builder.addToken((Token)new Ranges(output));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitEcommand(DirectivesParser.EcommandContext ctx) {
        this.builder.addToken((Token)new DirectiveName(ctx.Identifier().getText()));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitColumn(DirectivesParser.ColumnContext ctx) {
        this.builder.addToken((Token)new ColumnName(ctx.Column().getText().substring(1)));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitText(DirectivesParser.TextContext ctx) {
        String value = ctx.String().getText();
        this.builder.addToken((Token)new Text(value.substring(1, value.length() - 1)));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitNumber(DirectivesParser.NumberContext ctx) {
        LazyNumber number = new LazyNumber(ctx.Number().getText());
        this.builder.addToken((Token)new Numeric(number));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitBool(DirectivesParser.BoolContext ctx) {
        this.builder.addToken((Token)new Bool(Boolean.valueOf(ctx.Bool().getText())));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitCondition(DirectivesParser.ConditionContext ctx) {
        int childCount = ctx.getChildCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < childCount - 1; ++i) {
            ParseTree child = ctx.getChild(i);
            sb.append(child.getText()).append(" ");
        }
        this.builder.addToken((Token)new Expression(sb.toString()));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitCommand(DirectivesParser.CommandContext ctx) {
        this.builder.addToken((Token)new DirectiveName(ctx.Identifier().getText()));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitColList(DirectivesParser.ColListContext ctx) {
        List<TerminalNode> columns = ctx.Column();
        ArrayList<String> names = new ArrayList<String>();
        for (TerminalNode column : columns) {
            names.add(column.getText().substring(1));
        }
        this.builder.addToken((Token)new ColumnNameList(names));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitNumberList(DirectivesParser.NumberListContext ctx) {
        List<TerminalNode> numbers = ctx.Number();
        ArrayList<LazyNumber> numerics = new ArrayList<LazyNumber>();
        for (TerminalNode number : numbers) {
            numerics.add(new LazyNumber(number.getText()));
        }
        this.builder.addToken((Token)new NumericList(numerics));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitBoolList(DirectivesParser.BoolListContext ctx) {
        List<TerminalNode> bools = ctx.Bool();
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        for (TerminalNode bool : bools) {
            booleans.add(Boolean.parseBoolean(bool.getText()));
        }
        this.builder.addToken((Token)new BoolList(booleans));
        return this.builder;
    }

    @Override
    public RecipeSymbol.Builder visitStringList(DirectivesParser.StringListContext ctx) {
        List<TerminalNode> strings = ctx.String();
        ArrayList<String> strs = new ArrayList<String>();
        for (TerminalNode string : strings) {
            String text = string.getText();
            strs.add(text.substring(1, text.length() - 1));
        }
        this.builder.addToken((Token)new TextList(strs));
        return this.builder;
    }

    private SourceInfo getOriginalSource(ParserRuleContext ctx) {
        int a = ctx.getStart().getStartIndex();
        int b = ctx.getStop().getStopIndex();
        Interval interval = new Interval(a, b);
        String text = ctx.start.getInputStream().getText(interval);
        int lineno = ctx.getStart().getLine();
        int column = ctx.getStart().getCharPositionInLine();
        return new SourceInfo(lineno, column, text);
    }
}

