/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import io.cdap.wrangler.api.CompileException;
import io.cdap.wrangler.api.CompileStatus;
import io.cdap.wrangler.api.Compiler;
import io.cdap.wrangler.api.RecipeSymbol;
import io.cdap.wrangler.parser.DirectivesLexer;
import io.cdap.wrangler.parser.DirectivesParser;
import io.cdap.wrangler.parser.RecipeVisitor;
import io.cdap.wrangler.parser.SyntaxErrorListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.tool.GrammarParserInterpreter;
import org.apache.twill.filesystem.Location;

public final class RecipeCompiler
implements Compiler {
    public CompileStatus compile(String recipe) throws CompileException {
        return this.compile((CharStream)CharStreams.fromString((String)recipe));
    }

    public CompileStatus compile(Location location) throws CompileException {
        try {
            return this.compile(CharStreams.fromStream((InputStream)location.getInputStream()));
        }
        catch (IOException e) {
            throw new CompileException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    public CompileStatus compile(Path path) throws CompileException {
        try {
            return this.compile(CharStreams.fromPath((Path)path));
        }
        catch (IOException e) {
            throw new CompileException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            throw new CompileException(e.getMessage(), e);
        }
    }

    private CompileStatus compile(CharStream stream) throws CompileException {
        try {
            SyntaxErrorListener errorListener = new SyntaxErrorListener();
            DirectivesLexer lexer = new DirectivesLexer(stream);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            DirectivesParser parser = new DirectivesParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            parser.setErrorHandler((ANTLRErrorStrategy)new GrammarParserInterpreter.BailButConsumeErrorStrategy());
            parser.setBuildParseTree(true);
            DirectivesParser.StatementsContext tree = parser.statements();
            if (errorListener.hasErrors()) {
                return new CompileStatus(true, errorListener.iterator());
            }
            RecipeVisitor visitor = new RecipeVisitor();
            visitor.visit((ParseTree)tree);
            RecipeSymbol symbol = visitor.getCompiledUnit();
            return new CompileStatus(symbol);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new CompileException("Issue in compiling directives");
        }
    }
}

