/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import com.google.common.base.Joiner;
import edu.emory.mathcs.backport.java.util.Arrays;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.GrammarMigrator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class MigrateToV2
implements GrammarMigrator {
    private final List<String> recipe;

    public MigrateToV2(List<String> recipe) {
        this.recipe = recipe;
    }

    public MigrateToV2(String[] recipe) {
        this(Arrays.asList((Object[])recipe));
    }

    public MigrateToV2(@Nullable String recipe, String delimiter) {
        this(recipe != null ? recipe.trim().split(delimiter) : new String[]{});
    }

    public MigrateToV2(String recipe) {
        this(recipe, "\n");
    }

    public String migrate() throws DirectiveParseException {
        ArrayList<String> transformed = new ArrayList<String>();
        int lineno = 1;
        for (String directive : this.recipe) {
            String command;
            if ((directive = directive.trim()).isEmpty() || directive.startsWith("//") || directive.startsWith("#") && !directive.startsWith("#pragma")) continue;
            if (directive.contains("exp:") || directive.contains("prop:")) {
                if (directive.endsWith(";")) {
                    transformed.add(directive);
                    continue;
                }
                transformed.add(directive + ";");
                continue;
            }
            if (directive.startsWith("#pragma")) {
                transformed.add(directive);
                continue;
            }
            if (directive.endsWith(";")) {
                directive = directive.substring(0, directive.length() - 1);
            }
            StringTokenizer tokenizer = new StringTokenizer(directive, " ");
            switch (command = tokenizer.nextToken()) {
                case "set": {
                    switch (tokenizer.nextToken()) {
                        case "column": {
                            String column = MigrateToV2.getNextToken(tokenizer, "set column", "column-name", lineno);
                            String expr = MigrateToV2.getNextToken(tokenizer, "\n", "set column", "jexl-expression", lineno);
                            transformed.add(String.format("set-column %s exp:{%s};", MigrateToV2.col(column), expr));
                            break;
                        }
                        case "columns": {
                            String columns = MigrateToV2.getNextToken(tokenizer, "\n", "set columns", "name1, name2, ...", lineno);
                            String[] cols = columns.split(",");
                            transformed.add(String.format("set-headers %s;", MigrateToV2.toColumArray(cols)));
                        }
                    }
                    break;
                }
                case "rename": {
                    String oldcol = MigrateToV2.getNextToken(tokenizer, command, "old", lineno);
                    String newcol = MigrateToV2.getNextToken(tokenizer, command, "new", lineno);
                    transformed.add(String.format("rename %s %s;", MigrateToV2.col(oldcol), MigrateToV2.col(newcol)));
                    break;
                }
                case "set-type": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    String type = MigrateToV2.getNextToken(tokenizer, command, "type", lineno);
                    transformed.add(String.format("set-type %s %s;", MigrateToV2.col(col), type));
                    break;
                }
                case "drop": {
                    String columns = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String[] cols = columns.split(",");
                    transformed.add(String.format("drop %s;", MigrateToV2.toColumArray(cols)));
                    break;
                }
                case "merge": {
                    String col1 = MigrateToV2.getNextToken(tokenizer, command, "first", lineno);
                    String col2 = MigrateToV2.getNextToken(tokenizer, command, "second", lineno);
                    String dest = MigrateToV2.getNextToken(tokenizer, command, "new-column", lineno);
                    String delimiter = MigrateToV2.getNextToken(tokenizer, "\n", command, "delimiter", lineno);
                    transformed.add(String.format("merge %s %s %s %s;", MigrateToV2.col(col1), MigrateToV2.col(col2), MigrateToV2.col(dest), MigrateToV2.quote(delimiter)));
                    break;
                }
                case "uppercase": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("uppercase %s;", MigrateToV2.col(col)));
                    break;
                }
                case "lowercase": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("lowercase %s;", MigrateToV2.col(col)));
                    break;
                }
                case "titlecase": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("titlecase %s;", MigrateToV2.col(col)));
                    break;
                }
                case "indexsplit": {
                    String source = MigrateToV2.getNextToken(tokenizer, command, "source", lineno);
                    String startStr = MigrateToV2.getNextToken(tokenizer, command, "start", lineno);
                    String endStr = MigrateToV2.getNextToken(tokenizer, command, "end", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    transformed.add(String.format("indexsplit %s %s %s %s;", MigrateToV2.col(source), startStr, endStr, MigrateToV2.col(destination)));
                    break;
                }
                case "split": {
                    String source = MigrateToV2.getNextToken(tokenizer, command, "source-column-name", lineno);
                    String delimiter = MigrateToV2.getNextToken(tokenizer, command, "delimiter", lineno);
                    String firstCol = MigrateToV2.getNextToken(tokenizer, command, "new-column-1", lineno);
                    String secondCol = MigrateToV2.getNextToken(tokenizer, command, "new-column-2", lineno);
                    transformed.add(String.format("split %s %s %s %s;", MigrateToV2.col(source), MigrateToV2.quote(delimiter), MigrateToV2.col(firstCol), MigrateToV2.col(secondCol)));
                    break;
                }
                case "filter-row-if-matched": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String pattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "regex", lineno);
                    transformed.add(String.format("filter-by-regex if-matched %s %s;", MigrateToV2.col(column), MigrateToV2.quote(pattern)));
                    break;
                }
                case "filter-row-if-not-matched": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String pattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "regex", lineno);
                    transformed.add(String.format("filter-by-regex if-not-matched %s %s;", MigrateToV2.col(column), MigrateToV2.quote(pattern)));
                    break;
                }
                case "filter-row-if-true": {
                    String condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                    transformed.add(String.format("filter-row exp:{%s} true;", condition));
                    break;
                }
                case "filter-row-if-false": {
                    String condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                    transformed.add(String.format("filter-row exp:{%s} false;", condition));
                    break;
                }
                case "filter-rows-on": {
                    String pattern;
                    String column;
                    String condition;
                    String cmd = MigrateToV2.getNextToken(tokenizer, command, "command", lineno);
                    if (cmd.equalsIgnoreCase("condition-false")) {
                        condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                        transformed.add(String.format("filter-row exp:{%s} false;", condition));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("condition-true")) {
                        condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                        transformed.add(String.format("filter-row exp:{%s} true;", condition));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("empty-or-null-columns")) {
                        String columns = MigrateToV2.getNextToken(tokenizer, "\n", command, "columns", lineno);
                        transformed.add(String.format("filter-empty-or-null %s;", MigrateToV2.toColumArray(columns.split(","))));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("regex-match")) {
                        column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                        pattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "regex", lineno);
                        transformed.add(String.format("filter-by-regex if-matched %s %s;", MigrateToV2.col(column), MigrateToV2.quote(pattern)));
                        break;
                    }
                    if (cmd.equalsIgnoreCase("regex-not-match")) {
                        column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                        pattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "regex", lineno);
                        transformed.add(String.format("filter-by-regex if-not-matched %s %s;", MigrateToV2.col(column), MigrateToV2.quote(pattern)));
                        break;
                    }
                    throw new DirectiveParseException("filter-rows-on", String.format("Unknown option '%s' specified at line no %s", cmd, lineno));
                }
                case "set-variable": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String expression = MigrateToV2.getNextToken(tokenizer, "\n", command, "expression", lineno);
                    transformed.add(String.format("set-variable %s exp:{%s};", column, expression));
                    break;
                }
                case "increment-variable": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String value = MigrateToV2.getNextToken(tokenizer, command, "value", lineno);
                    String expression = MigrateToV2.getNextToken(tokenizer, "\n", command, "expression", lineno);
                    transformed.add(String.format("increment-variable %s %s exp:{%s};", column, value, expression));
                    break;
                }
                case "mask-number": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String mask = MigrateToV2.getNextToken(tokenizer, command, "pattern", lineno);
                    transformed.add(String.format("mask-number %s %s;", MigrateToV2.col(column), MigrateToV2.quote(mask)));
                    break;
                }
                case "mask-shuffle": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("mask-shuffle %s;", MigrateToV2.col(column)));
                    break;
                }
                case "format-date": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", 1);
                    String format = MigrateToV2.getNextToken(tokenizer, "\n", command, "format", lineno);
                    transformed.add(String.format("format-date %s %s;", MigrateToV2.col(column), MigrateToV2.quote(format)));
                    break;
                }
                case "format-unix-timestamp": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String dstDatePattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "destination-format", lineno);
                    transformed.add(String.format("format-unix-timestamp %s %s;", MigrateToV2.col(column), MigrateToV2.quote(dstDatePattern)));
                    break;
                }
                case "quantize": {
                    String column1 = MigrateToV2.getNextToken(tokenizer, command, "source-column", lineno);
                    String column2 = MigrateToV2.getNextToken(tokenizer, command, "destination-column", lineno);
                    String ranges = MigrateToV2.getNextToken(tokenizer, "\n", command, "destination-column", lineno);
                    transformed.add(String.format("quantize %s %s %s;", MigrateToV2.col(column1), MigrateToV2.col(column2), ranges));
                    break;
                }
                case "find-and-replace": {
                    String columns = MigrateToV2.getNextToken(tokenizer, command, "columns", lineno);
                    String expression = MigrateToV2.getNextToken(tokenizer, "\n", command, "sed-script", lineno);
                    transformed.add(String.format("find-and-replace %s %s;", MigrateToV2.toColumArray(columns.split(",")), MigrateToV2.quote(expression)));
                    break;
                }
                case "parse-as-csv": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String delimStr = MigrateToV2.getNextToken(tokenizer, command, "delimiter", lineno);
                    if (delimStr.endsWith(";")) {
                        delimStr = delimStr.substring(0, delimStr.length() - 1);
                    }
                    String hasHeaderLinesOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "true|false", lineno, true);
                    transformed.add(String.format("parse-as-csv %s %s %s;", MigrateToV2.col(column), MigrateToV2.quote(delimStr), hasHeaderLinesOpt == null ? "" : hasHeaderLinesOpt));
                    break;
                }
                case "parse-as-json": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String depthOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "depth", lineno, true);
                    transformed.add(String.format("parse-as-json %s %s;", MigrateToV2.col(column), depthOpt));
                    break;
                }
                case "parse-as-avro": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String schemaId = MigrateToV2.getNextToken(tokenizer, command, "schema-id", lineno);
                    String type = MigrateToV2.getNextToken(tokenizer, command, "type", lineno);
                    String versionOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "depth", lineno, true);
                    transformed.add(String.format("parse-as-avro %s %s %s %s;", MigrateToV2.col(column), schemaId, type, versionOpt));
                    break;
                }
                case "parse-as-protobuf": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String schemaId = MigrateToV2.getNextToken(tokenizer, command, "schema-id", lineno);
                    String recordName = MigrateToV2.getNextToken(tokenizer, command, "record-name", lineno);
                    String versionOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "depth", lineno, true);
                    transformed.add(String.format("parse-as-protobuf %s %s %s %s;", MigrateToV2.col(column), schemaId, MigrateToV2.quote(recordName), versionOpt));
                    break;
                }
                case "json-path": {
                    String src = MigrateToV2.getNextToken(tokenizer, command, "source", lineno);
                    String dest = MigrateToV2.getNextToken(tokenizer, command, "dest", lineno);
                    String path = MigrateToV2.getNextToken(tokenizer, "\n", command, "json-path", lineno);
                    transformed.add(String.format("json-path %s %s %s;", MigrateToV2.col(src), MigrateToV2.col(dest), MigrateToV2.quote(path)));
                    break;
                }
                case "set-charset": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String charset = MigrateToV2.getNextToken(tokenizer, "\n", command, "charset", lineno, true);
                    transformed.add(String.format("set-charset %s %s;", MigrateToV2.col(column), charset));
                    break;
                }
                case "invoke-http": {
                    String url = MigrateToV2.getNextToken(tokenizer, command, "url", lineno);
                    String columnsOpt = MigrateToV2.getNextToken(tokenizer, command, "columns", lineno);
                    String headers = MigrateToV2.getNextToken(tokenizer, "\n", command, "headers", lineno, true);
                    transformed.add(String.format("invoke-http %s %s %s;", MigrateToV2.quote(url), MigrateToV2.toColumArray(columnsOpt.split(",")), MigrateToV2.quote(headers)));
                    break;
                }
                case "set-record-delim": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String delimiter = MigrateToV2.getNextToken(tokenizer, command, "delimiter", lineno);
                    String limitStr = MigrateToV2.getNextToken(tokenizer, "\n", column, "limit", lineno, true);
                    transformed.add(String.format("set-record-delim %s %s %s;", MigrateToV2.col(column), MigrateToV2.quote(delimiter), limitStr));
                    break;
                }
                case "parse-as-fixed-length": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String widthStr = MigrateToV2.getNextToken(tokenizer, command, "widths", lineno);
                    String padding = MigrateToV2.getNextToken(tokenizer, "\n", column, "padding", lineno, true);
                    transformed.add(String.format("parse-as-fixed-length %s %s %s;", MigrateToV2.col(column), widthStr, MigrateToV2.quote(padding)));
                    break;
                }
                case "split-to-rows": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String regex = MigrateToV2.getNextToken(tokenizer, "\n", "separator", lineno);
                    transformed.add(String.format("split-to-rows %s %s;", MigrateToV2.col(column), MigrateToV2.quote(regex)));
                    break;
                }
                case "split-to-columns": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String regex = MigrateToV2.getNextToken(tokenizer, "\n", "regex", lineno);
                    transformed.add(String.format("split-to-columns %s %s;", MigrateToV2.col(column), MigrateToV2.quote(regex)));
                    break;
                }
                case "parse-xml-to-json": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String depthOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "depth", lineno, true);
                    transformed.add(String.format("parse-xml-to-json %s %s;", MigrateToV2.col(column), depthOpt));
                    break;
                }
                case "parse-as-xml": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("parse-as-xml %s;", MigrateToV2.col(column)));
                    break;
                }
                case "xpath": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    String xpath = MigrateToV2.getNextToken(tokenizer, "\n", command, "xpath", lineno);
                    transformed.add(String.format("xpath %s %s %s;", MigrateToV2.col(column), MigrateToV2.col(destination), MigrateToV2.quote(xpath)));
                    break;
                }
                case "xpath-array": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    String xpath = MigrateToV2.getNextToken(tokenizer, "\n", command, "xpath", lineno);
                    transformed.add(String.format("xpath-array %s %s %s;", MigrateToV2.col(column), MigrateToV2.col(destination), MigrateToV2.quote(xpath)));
                    break;
                }
                case "flatten": {
                    String cols = MigrateToV2.getNextToken(tokenizer, command, "columns", lineno);
                    transformed.add(String.format("flatten %s;", MigrateToV2.toColumArray(cols.split(","))));
                    break;
                }
                case "copy": {
                    String source = MigrateToV2.getNextToken(tokenizer, command, "source", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    String forceOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "force", lineno, true);
                    if (forceOpt == null || forceOpt.isEmpty()) {
                        transformed.add(String.format("copy %s %s;", MigrateToV2.col(source), MigrateToV2.col(destination)));
                        break;
                    }
                    transformed.add(String.format("copy %s %s %s;", MigrateToV2.col(source), MigrateToV2.col(destination), forceOpt));
                    break;
                }
                case "fill-null-or-empty": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String value = MigrateToV2.getNextToken(tokenizer, "\n", command, "fixed-value", lineno, false);
                    transformed.add(String.format("fill-null-or-empty %s %s;", MigrateToV2.col(column), MigrateToV2.quote(value)));
                    break;
                }
                case "cut-character": {
                    String source = MigrateToV2.getNextToken(tokenizer, command, "source", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    String range = MigrateToV2.getNextToken(tokenizer, command, "range", lineno);
                    transformed.add(String.format("cut-character %s %s %s;", MigrateToV2.col(source), MigrateToV2.col(destination), MigrateToV2.quote(range)));
                    break;
                }
                case "generate-uuid": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("generate-uuid %s;", MigrateToV2.col(column)));
                    break;
                }
                case "url-encode": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("url-encode %s;", MigrateToV2.col(column)));
                    break;
                }
                case "url-decode": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("url-decode %s;", MigrateToV2.col(column)));
                    break;
                }
                case "parse-as-log": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String format = MigrateToV2.getNextToken(tokenizer, "\n", command, "format", lineno);
                    transformed.add(String.format("parse-as-log %s %s;", MigrateToV2.col(column), MigrateToV2.quote(format)));
                    break;
                }
                case "parse-as-date": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String timezone = MigrateToV2.getNextToken(tokenizer, "\n", command, "timezone", lineno, true);
                    transformed.add(String.format("parse-as-date %s %s;", MigrateToV2.col(column), MigrateToV2.quote(timezone)));
                    break;
                }
                case "parse-as-simple-date": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String pattern = MigrateToV2.getNextToken(tokenizer, "\n", command, "format", lineno);
                    transformed.add(String.format("parse-as-simple-date %s %s;", MigrateToV2.col(column), MigrateToV2.quote(pattern)));
                    break;
                }
                case "diff-date": {
                    String column1 = MigrateToV2.getNextToken(tokenizer, command, "column1", lineno);
                    String column2 = MigrateToV2.getNextToken(tokenizer, command, "column2", lineno);
                    String destColumn = MigrateToV2.getNextToken(tokenizer, "\n", command, "destColumn", lineno);
                    transformed.add(String.format("diff-date %s %s %s;", MigrateToV2.col(column1), MigrateToV2.col(column2), MigrateToV2.col(destColumn)));
                    break;
                }
                case "keep": {
                    String columns = MigrateToV2.getNextToken(tokenizer, command, "columns", lineno);
                    transformed.add(String.format("keep %s;", MigrateToV2.toColumArray(columns.split(","))));
                    break;
                }
                case "parse-as-hl7": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String depthOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "depth", lineno, true);
                    transformed.add(String.format("parse-as-hl7 %s %s;", MigrateToV2.col(column), depthOpt));
                    break;
                }
                case "split-email": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("split-email %s;", MigrateToV2.col(column)));
                    break;
                }
                case "swap": {
                    String column1 = MigrateToV2.getNextToken(tokenizer, command, "column1", lineno);
                    String column2 = MigrateToV2.getNextToken(tokenizer, command, "column2", lineno);
                    transformed.add(String.format("swap %s %s;", MigrateToV2.col(column1), MigrateToV2.col(column2)));
                    break;
                }
                case "hash": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String algorithm = MigrateToV2.getNextToken(tokenizer, command, "algorithm", lineno);
                    String encodeOpt = MigrateToV2.getNextToken(tokenizer, "\n", command, "encode", lineno, true);
                    transformed.add(String.format("hash %s %s %s;", MigrateToV2.col(column), MigrateToV2.quote(algorithm), encodeOpt));
                    break;
                }
                case "write-as-json-map": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("write-as-json-map %s;", MigrateToV2.col(column)));
                    break;
                }
                case "write-as-json-object": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String columnsStr = MigrateToV2.getNextToken(tokenizer, "\n", command, "columns", lineno);
                    transformed.add(String.format("write-as-json-object %s %s;", MigrateToV2.col(column), MigrateToV2.toColumArray(columnsStr.split(","))));
                    break;
                }
                case "write-as-csv": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("write-as-csv %s;", MigrateToV2.col(column)));
                    break;
                }
                case "parse-as-avro-file": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("parse-as-avro-file %s;", MigrateToV2.col(column)));
                    break;
                }
                case "send-to-error": {
                    String condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                    transformed.add(String.format("send-to-error exp:{%s};", condition));
                    break;
                }
                case "fail": {
                    String condition = MigrateToV2.getNextToken(tokenizer, "\n", command, "condition", lineno);
                    transformed.add(String.format("fail exp:{%s};", condition));
                    break;
                }
                case "text-distance": {
                    String method = MigrateToV2.getNextToken(tokenizer, command, "method", lineno);
                    String column1 = MigrateToV2.getNextToken(tokenizer, command, "column1", lineno);
                    String column2 = MigrateToV2.getNextToken(tokenizer, command, "column2", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    transformed.add(String.format("text-distance %s %s %s %s;", MigrateToV2.quote(method), MigrateToV2.col(column1), MigrateToV2.col(column2), MigrateToV2.col(destination)));
                    break;
                }
                case "text-metric": {
                    String method = MigrateToV2.getNextToken(tokenizer, command, "method", lineno);
                    String column1 = MigrateToV2.getNextToken(tokenizer, command, "column1", lineno);
                    String column2 = MigrateToV2.getNextToken(tokenizer, command, "column2", lineno);
                    String destination = MigrateToV2.getNextToken(tokenizer, command, "destination", lineno);
                    transformed.add(String.format("text-metric %s %s %s %s;", MigrateToV2.quote(method), MigrateToV2.col(column1), MigrateToV2.col(column2), MigrateToV2.col(destination)));
                    break;
                }
                case "catalog-lookup": {
                    String type = MigrateToV2.getNextToken(tokenizer, command, "type", lineno);
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("catalog-lookup %s %s;", MigrateToV2.quote(type), MigrateToV2.col(column)));
                    break;
                }
                case "table-lookup": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String table = MigrateToV2.getNextToken(tokenizer, command, "table", lineno);
                    transformed.add(String.format("table-lookup %s %s;", MigrateToV2.col(column), MigrateToV2.quote(table)));
                    break;
                }
                case "stemming": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("stemming %s;", MigrateToV2.col(column)));
                    break;
                }
                case "columns-replace": {
                    String sed = MigrateToV2.getNextToken(tokenizer, command, "sed-expression", lineno);
                    transformed.add(String.format("columns-replace %s;", MigrateToV2.quote(sed)));
                    break;
                }
                case "extract-regex-groups": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String regex = MigrateToV2.getNextToken(tokenizer, command, "regex", lineno);
                    transformed.add(String.format("extract-regex-groups %s %s;", MigrateToV2.col(column), MigrateToV2.quote(regex)));
                    break;
                }
                case "split-url": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("split-url %s;", MigrateToV2.col(column)));
                    break;
                }
                case "cleanse-column-names": {
                    transformed.add("cleanse-column-names;");
                    break;
                }
                case "change-column-case": {
                    String casing = MigrateToV2.getNextToken(tokenizer, command, "case", lineno);
                    transformed.add(String.format("change-column-case %s;", casing));
                    break;
                }
                case "set-column": {
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    String expr = MigrateToV2.getNextToken(tokenizer, "\n", command, "expression", lineno);
                    transformed.add(String.format("set-column %s exp:{%s};", MigrateToV2.col(column), expr));
                    break;
                }
                case "encode": {
                    String type = MigrateToV2.getNextToken(tokenizer, command, "type", lineno);
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("encode %s %s;", MigrateToV2.quote(type), MigrateToV2.col(column)));
                    break;
                }
                case "decode": {
                    String type = MigrateToV2.getNextToken(tokenizer, command, "type", lineno);
                    String column = MigrateToV2.getNextToken(tokenizer, command, "column", lineno);
                    transformed.add(String.format("decode %s %s;", MigrateToV2.quote(type), MigrateToV2.col(column)));
                    break;
                }
                case "trim": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("trim %s;", MigrateToV2.col(col)));
                    break;
                }
                case "ltrim": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("ltrim %s;", MigrateToV2.col(col)));
                    break;
                }
                case "rtrim": {
                    String col = MigrateToV2.getNextToken(tokenizer, command, "col", lineno);
                    transformed.add(String.format("rtrim %s;", MigrateToV2.col(col)));
                    break;
                }
                default: {
                    if (!directive.endsWith(";") && !directive.startsWith("$")) {
                        transformed.add(directive + ";");
                        break;
                    }
                    transformed.add(directive);
                }
            }
            ++lineno;
        }
        return Joiner.on((char)'\n').join(transformed);
    }

    private static String quote(String value) {
        if (value == null) {
            return "";
        }
        if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
            return value;
        }
        if (value.contains("'")) {
            return String.format("\"%s\"", value);
        }
        return String.format("'%s'", value);
    }

    private static String col(String value) {
        if (value.startsWith(":")) {
            return value;
        }
        return String.format(":%s", value);
    }

    private static String toColumArray(String[] columns) {
        ArrayList<String> array = new ArrayList<String>();
        for (String column : columns) {
            array.add(MigrateToV2.col(StringUtils.trim((String)column)));
        }
        return Joiner.on((String)",").join(array);
    }

    public static String getNextToken(StringTokenizer tokenizer, String directive, String field, int lineno) throws DirectiveParseException {
        return MigrateToV2.getNextToken(tokenizer, null, directive, field, lineno, false);
    }

    public static String getNextToken(StringTokenizer tokenizer, String delimiter, String directive, String field, int lineno) throws DirectiveParseException {
        return MigrateToV2.getNextToken(tokenizer, delimiter, directive, field, lineno, false);
    }

    public static String getNextToken(StringTokenizer tokenizer, String delimiter, String directive, String field, int lineno, boolean optional) throws DirectiveParseException {
        String value = null;
        if (tokenizer.hasMoreTokens()) {
            value = delimiter == null ? tokenizer.nextToken().trim() : tokenizer.nextToken(delimiter).trim();
        } else if (!optional) {
            throw new DirectiveParseException(directive, String.format("Missing field '%s' at line number %d.", field, lineno));
        }
        return value;
    }
}

