/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import com.google.common.base.Joiner;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.CompileException;
import io.cdap.wrangler.api.CompileStatus;
import io.cdap.wrangler.api.Compiler;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveContext;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveNotFoundException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.TokenGroup;
import io.cdap.wrangler.api.parser.DirectiveName;
import io.cdap.wrangler.api.parser.SyntaxError;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.parser.MapArguments;
import io.cdap.wrangler.parser.NoOpDirectiveContext;
import io.cdap.wrangler.parser.RecipeCompiler;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GrammarBasedParser
implements RecipeParser {
    private static final char EOL = '\n';
    private final String namespace;
    private final Compiler compiler = new RecipeCompiler();
    private final DirectiveRegistry registry;
    private final String recipe;
    private final List<Directive> directives;
    private DirectiveContext context;

    public GrammarBasedParser(String namespace, String[] directives, DirectiveRegistry registry) {
        this(namespace, Joiner.on((char)'\n').join((Object[])directives), registry);
    }

    public GrammarBasedParser(String namespace, String recipe, DirectiveRegistry registry) {
        this.namespace = namespace;
        this.recipe = recipe;
        this.registry = registry;
        this.directives = new ArrayList<Directive>();
        this.context = new NoOpDirectiveContext();
    }

    public List<Directive> parse() throws DirectiveLoadException, DirectiveNotFoundException, DirectiveParseException {
        try {
            CompileStatus status = this.compiler.compile(this.recipe);
            if (!status.isSuccess()) {
                Iterator errors = status.getErrors();
                String prefix = "Encountered syntax error, please ensure the directive is valid:\n";
                throw new DirectiveParseException(prefix + ((SyntaxError)errors.next()).getMessage(), errors);
            }
            for (TokenGroup next : status.getSymbols()) {
                if (next == null) continue;
                String command = ((DirectiveName)next.get(0)).value();
                String root = command;
                if (this.context.hasAlias(root)) {
                    root = this.context.getAlias(command);
                }
                if (!root.equals(command) && this.context.isExcluded(command)) {
                    throw new DirectiveParseException(command, String.format("Aliased directive '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
                }
                if (this.context.isExcluded(root)) {
                    throw new DirectiveParseException(command, String.format("Directive '%s' has been configured as restricted directive and is hence unavailable. Please contact your administrator", command));
                }
                DirectiveInfo info = this.registry.get(this.namespace, root);
                if (info == null) {
                    throw new DirectiveNotFoundException(String.format("Directive '%s' not found in system and user scope. Check the name of directive.", command));
                }
                Directive directive = info.instance();
                UsageDefinition definition = directive.define();
                MapArguments arguments = new MapArguments(definition, next);
                directive.initialize((Arguments)arguments);
                this.directives.add(directive);
            }
        }
        catch (CompileException e) {
            throw new DirectiveParseException(e.getMessage(), e.iterator());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DirectiveParseException(e.getMessage());
        }
        return this.directives;
    }

    public void initialize(DirectiveContext context) {
        this.context = context == null ? new NoOpDirectiveContext() : context;
    }
}

